/*
 * Decompiled with CFR 0.152.
 */
package com.southernstorm.noise.protocol;

import com.southernstorm.noise.protocol.DHState;
import com.southernstorm.noise.protocol.Noise;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import net.i2p.crypto.EncType;
import net.i2p.crypto.KeyFactory;
import net.i2p.crypto.KeyPair;
import net.i2p.router.crypto.pqc.MLKEM;

class MLKEMDHState
implements DHState,
Cloneable {
    private final EncType type;
    private final byte[] publicKey;
    private final byte[] privateKey;
    private int mode;
    private final KeyFactory _hdh;

    public MLKEMDHState(boolean isAlice, String patternId) {
        this(isAlice, null, patternId);
    }

    public MLKEMDHState(KeyFactory hdh, String patternId) {
        this(true, hdh, patternId);
    }

    private MLKEMDHState(boolean isAlice, KeyFactory hdh, String patternId) {
        if (patternId.equals("IKhfs512")) {
            this.type = isAlice ? EncType.MLKEM512_X25519_INT : EncType.MLKEM512_X25519_CT;
        } else if (patternId.equals("IKhfs768")) {
            this.type = isAlice ? EncType.MLKEM768_X25519_INT : EncType.MLKEM768_X25519_CT;
        } else if (patternId.equals("IKhfs1024")) {
            this.type = isAlice ? EncType.MLKEM1024_X25519_INT : EncType.MLKEM1024_X25519_CT;
        } else {
            throw new IllegalArgumentException("Handshake pattern is not recognized");
        }
        this.publicKey = new byte[this.type.getPubkeyLen()];
        this.privateKey = isAlice ? new byte[this.type.getPrivkeyLen()] : null;
        this.mode = 0;
        this._hdh = hdh;
    }

    @Override
    public void destroy() {
        this.clearKey();
    }

    @Override
    public String getDHName() {
        return "MLKEM";
    }

    @Override
    public int getPublicKeyLength() {
        return this.type.getPubkeyLen();
    }

    @Override
    @Deprecated
    public int getPrivateKeyLength() {
        return this.type.getPrivkeyLen();
    }

    @Override
    public int getSharedKeyLength() {
        return 32;
    }

    @Override
    public void generateKeyPair() {
        if (this._hdh == null) {
            throw new IllegalStateException("Don't keygen PQ on Bob side");
        }
        KeyPair kp = this._hdh.getKeys();
        System.arraycopy(kp.getPrivate().getData(), 0, this.privateKey, 0, this.type.getPrivkeyLen());
        System.arraycopy(kp.getPublic().getData(), 0, this.publicKey, 0, this.type.getPubkeyLen());
        this.mode = 3;
    }

    @Override
    public void getPublicKey(byte[] key, int offset) {
        System.arraycopy(this.publicKey, 0, key, offset, this.type.getPubkeyLen());
    }

    @Override
    public void setPublicKey(byte[] key, int offset) {
        System.arraycopy(key, offset, this.publicKey, 0, this.type.getPubkeyLen());
        if (this.privateKey != null) {
            Arrays.fill(this.privateKey, (byte)0);
        }
        this.mode = 1;
    }

    @Override
    @Deprecated
    public void getPrivateKey(byte[] key, int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void setPrivateKey(byte[] key, int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void setKeys(byte[] privkey, int privoffset, byte[] pubkey, int puboffset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setToNullPublicKey() {
        Arrays.fill(this.publicKey, (byte)0);
        if (this.privateKey != null) {
            Arrays.fill(this.privateKey, (byte)0);
        }
        this.mode = 1;
    }

    @Override
    public void clearKey() {
        Noise.destroy(this.publicKey);
        if (this.privateKey != null) {
            Noise.destroy(this.privateKey);
        }
        this.mode = 0;
    }

    @Override
    public boolean hasPublicKey() {
        return (this.mode & 1) != 0;
    }

    @Override
    public boolean hasPrivateKey() {
        return (this.mode & 2) != 0;
    }

    @Override
    public boolean isNullPublicKey() {
        if ((this.mode & 1) == 0) {
            return false;
        }
        int temp = 0;
        for (int index = 0; index < this.publicKey.length; ++index) {
            temp |= this.publicKey[index];
        }
        return temp == 0;
    }

    @Override
    public boolean hasEncodedPublicKey() {
        return false;
    }

    @Override
    @Deprecated
    public void getEncodedPublicKey(byte[] key, int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void calculate(byte[] sharedKey, int offset, DHState publicDH) {
        block5: {
            if (!(publicDH instanceof MLKEMDHState)) {
                throw new IllegalArgumentException("Incompatible DH algorithms");
            }
            try {
                if (this.hasPrivateKey()) {
                    byte[] sk = MLKEM.decaps(this.type, ((MLKEMDHState)publicDH).publicKey, this.privateKey);
                    System.arraycopy(sk, 0, sharedKey, offset, sk.length);
                    break block5;
                }
                if (!this.hasPublicKey()) {
                    byte[][] rv = MLKEM.encaps(this.type, ((MLKEMDHState)publicDH).publicKey);
                    byte[] ct = rv[0];
                    byte[] sk = rv[1];
                    System.arraycopy(sk, 0, sharedKey, offset, sk.length);
                    this.setPublicKey(ct, 0);
                    break block5;
                }
                throw new IllegalStateException();
            }
            catch (GeneralSecurityException gse) {
                throw new IllegalArgumentException(gse);
            }
        }
    }

    @Override
    public void copyFrom(DHState other) {
        if (!(other instanceof MLKEMDHState)) {
            throw new IllegalStateException("Mismatched DH key objects");
        }
        if (other == this) {
            return;
        }
        MLKEMDHState dh = (MLKEMDHState)other;
        if (dh.privateKey != null) {
            System.arraycopy(dh.privateKey, 0, this.privateKey, 0, this.type.getPrivkeyLen());
        }
        if (dh.publicKey != null) {
            System.arraycopy(dh.publicKey, 0, this.publicKey, 0, this.type.getPubkeyLen());
        }
        this.mode = dh.mode;
    }

    @Override
    public MLKEMDHState clone() throws CloneNotSupportedException {
        return (MLKEMDHState)super.clone();
    }
}

