/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts;

import org.codehaus.groovy.ast.ClassNode;
import org.gradle.api.Action;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.groovy.scripts.CachingScriptSource;
import org.gradle.groovy.scripts.Script;
import org.gradle.groovy.scripts.ScriptCompiler;
import org.gradle.groovy.scripts.ScriptCompilerFactory;
import org.gradle.groovy.scripts.ScriptRunner;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.internal.CompileOperation;
import org.gradle.groovy.scripts.internal.CompiledScript;
import org.gradle.groovy.scripts.internal.ScriptClassCompiler;
import org.gradle.groovy.scripts.internal.ScriptRunnerFactory;

public class DefaultScriptCompilerFactory
implements ScriptCompilerFactory {
    private final ScriptRunnerFactory scriptRunnerFactory;
    private final ScriptClassCompiler scriptClassCompiler;

    public DefaultScriptCompilerFactory(ScriptClassCompiler scriptClassCompiler, ScriptRunnerFactory scriptRunnerFactory) {
        this.scriptClassCompiler = scriptClassCompiler;
        this.scriptRunnerFactory = scriptRunnerFactory;
    }

    @Override
    public ScriptCompiler createCompiler(ScriptSource source) {
        return new ScriptCompilerImpl(source);
    }

    private class ScriptCompilerImpl
    implements ScriptCompiler {
        private final ScriptSource source;

        public ScriptCompilerImpl(ScriptSource source) {
            this.source = CachingScriptSource.of(source);
        }

        @Override
        public <T extends Script, M> ScriptRunner<T, M> compile(Class<T> scriptType, Object target, ClassLoaderScope targetScope, CompileOperation<M> extractingTransformer, Action<? super ClassNode> verifier) {
            CompiledScript<T, M> compiledScript = DefaultScriptCompilerFactory.this.scriptClassCompiler.compile(this.source, scriptType, target, targetScope, extractingTransformer, verifier);
            return DefaultScriptCompilerFactory.this.scriptRunnerFactory.create(compiledScript, this.source, targetScope.getExportClassLoader());
        }
    }
}

