/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java;

import org.graalvm.visualvm.heapviewer.java.Bundle;
import org.graalvm.visualvm.heapviewer.java.ClassNode;
import org.graalvm.visualvm.heapviewer.java.InstancesContainer;
import org.graalvm.visualvm.heapviewer.model.ContainerNode;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.ui.UIThresholds;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;

public final class ClassesContainer {
    private ClassesContainer() {
    }

    private static String getMoreNodesString(String moreNodesCount) {
        return Bundle.ClassesContainer_MoreNodes(moreNodesCount);
    }

    private static String getSamplesContainerString(String objectsCount) {
        return Bundle.ClassesContainer_SamplesContainer(objectsCount);
    }

    private static String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
        return Bundle.ClassesContainer_NodesContainer(firstNodeIdx, lastNodeIdx);
    }

    public static class ContainerNodes
    extends ContainerNode.Nodes<InstancesContainer.Objects> {
        public ContainerNodes(String name) {
            this(name, Integer.MAX_VALUE);
        }

        public ContainerNodes(String name, int maxItems) {
            super(name, maxItems);
        }
    }

    public static class Nodes
    extends ContainerNode.Nodes<ClassNode> {
        public Nodes(String name) {
            this(name, UIThresholds.MAX_CONTAINER_CLASSES);
        }

        public Nodes(String name, int maxItems) {
            super(name, maxItems);
        }

        @Override
        protected String getMoreNodesString(String moreNodesCount) {
            return ClassesContainer.getMoreNodesString(moreNodesCount);
        }

        @Override
        protected String getSamplesContainerString(String objectsCount) {
            return ClassesContainer.getSamplesContainerString(objectsCount);
        }

        @Override
        protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
            return ClassesContainer.getNodesContainerString(firstNodeIdx, lastNodeIdx);
        }
    }

    public static class Objects
    extends ContainerNode<JavaClass> {
        public Objects(String name) {
            this(name, UIThresholds.MAX_CONTAINER_CLASSES);
        }

        public Objects(String name, int maxItems) {
            super(name, maxItems);
        }

        @Override
        protected int getCount(JavaClass item, Heap heap) {
            return item.getInstancesCount();
        }

        @Override
        protected long getOwnSize(JavaClass item, Heap heap) {
            return item.getAllInstancesSize();
        }

        @Override
        protected long getRetainedSize(JavaClass item, Heap heap) {
            return DataType.RETAINED_SIZE.valuesAvailable(heap) ? item.getRetainedSizeByClass() : DataType.RETAINED_SIZE.getNotAvailableValue().longValue();
        }

        protected ClassNode createNode(JavaClass javaClass) {
            return new ClassNode(javaClass);
        }

        @Override
        protected String getMoreNodesString(String moreNodesCount) {
            return ClassesContainer.getMoreNodesString(moreNodesCount);
        }

        @Override
        protected String getSamplesContainerString(String objectsCount) {
            return ClassesContainer.getSamplesContainerString(objectsCount);
        }

        @Override
        protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
            return ClassesContainer.getNodesContainerString(firstNodeIdx, lastNodeIdx);
        }
    }
}

