/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class AquilaProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN_A = new PatternBuilder().text("$$").expression("[^,]*,").number("(d+),").number("(d+),").number("(-?d+.d+),").number("(-?d+.d+),").number("(dd)(dd)(dd)").number("(dd)(dd)(dd),").expression("([AV]),").groupBegin().number("(d+),").number("(d+),").number("(d+),").groupBegin().number("d+,").number("(d+),").number("([01]),").number("[01],").number("[01],").number("[01],").number("(?:d+,){3}").number("([01]),").number("([01]),").number("d+,").number("([01]),").number("[01],").number("(?:d+,){7}").number("[01],").number("(?:d+,){8}").number("([01]),").number("([01]),").number("([01]),").number("([01]),").or().number("(d+),").number("(?:d+,){3}").number("[01],").number("[01],").number("(?:d+,){3}").number("([01]),").number("(?:d+,){2}").number("[01],").number("([01]),").number("[01],").number("(?:d+,){5}").number("[01],").number("[01],").number("(?:d+,){6}").number("[01],").number("[01],").number("[01],[01],[01],[01],").number("(d+),").number("(d+),").number("(?:d+,){6}").expression("P([^,]+),").expression("D([^,]+),").number("-?d+,").number("-?d+,").number("-?d+,").number("d+,").or().number("(d+),").number("(d+),").number("(d+.d+),").number("(?:d+,){2}").number("(d+),").number("([01]),").number("[01],").number("[01],").number("[01],").number("(?:[01],){2}").number("[01],").number("([01]),").number("([01]),").number("(?:[01],){2}").number("([01]),").number("(?:[01],){6}").number("[01],").number("[01],").number("(?:[01],){4}").number("[01],").number("[01],").number("[01],").number("[01],").number("(?:[01],){4}").number("(d+),").number("(d+),").groupEnd().or().number("(d+),").expression("([^,]+),").groupEnd().text("*").number("xx").compile();

    public AquilaProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN_A, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("event", parser.nextInt(0));
        position.setLatitude(parser.nextDouble(0.0));
        position.setLongitude(parser.nextDouble(0.0));
        position.setTime(parser.nextDateTime());
        position.setValid(parser.next().equals("A"));
        if (parser.hasNext(3)) {
            position.set("rssi", parser.nextInt(0));
            position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble(0.0)));
            position.set("odometer", parser.nextInt(0));
        }
        if (parser.hasNext(9)) {
            position.set("fuel", parser.nextInt());
            position.set("in1", parser.next());
            position.set("charge", parser.next().equals("1"));
            position.set("in2", parser.next());
            position.set("ignition", parser.nextInt(0) == 1);
            int course = (parser.nextInt(0) << 3) + (parser.nextInt(0) << 2) + (parser.nextInt(0) << 1) + parser.nextInt(0);
            if (course > 0 && course <= 8) {
                position.setCourse((course - 1) * 45);
            }
        } else if (parser.hasNext(7)) {
            position.setCourse(parser.nextInt(0));
            position.set("charge", parser.next().equals("1"));
            position.set("ignition", parser.nextInt(0) == 1);
            position.set("power", parser.nextInt(0));
            position.set("battery", parser.nextInt(0));
            String obd = parser.next();
            position.set("obd", obd.substring(1, obd.length() - 1));
            String dtcs = parser.next();
            position.set("dtcs", dtcs.substring(1, dtcs.length() - 1).replace('|', ' '));
        } else if (parser.hasNext(10)) {
            position.setCourse(parser.nextInt(0));
            position.set("sat", parser.nextInt(0));
            position.set("hdop", parser.nextDouble(0.0));
            position.set("adc1", parser.nextInt(0));
            position.set("in1", parser.nextInt(0));
            position.set("charge", parser.next().equals("1"));
            position.set("in2", parser.nextInt(0));
            position.set("ignition", parser.nextInt(0) == 1);
            position.set("power", parser.nextInt(0));
            position.set("battery", parser.nextInt(0));
        } else if (parser.hasNext(2)) {
            position.set("sensorId", parser.nextInt());
            position.set("sensorData", parser.next());
        }
        return position;
    }
}

