/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Component;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.format.Formatting;
import org.assertj.swing.query.ComponentShowingQuery;
import org.assertj.swing.timing.Condition;

public class WaitForComponentToShowCondition
extends Condition {
    private Component c;

    public static WaitForComponentToShowCondition untilIsShowing(@Nonnull Component c) {
        return new WaitForComponentToShowCondition(c);
    }

    private WaitForComponentToShowCondition(@Nonnull Component c) {
        super(Strings.concat((Object[])new Object[]{"Component ", Formatting.format(c), " to show on the screen"}));
        this.c = (Component)Preconditions.checkNotNull((Object)c);
    }

    @Override
    public boolean test() {
        return ComponentShowingQuery.isShowing(this.c);
    }

    @Override
    protected void done() {
        this.c = null;
    }
}

