/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DependencyDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.UserType;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class SYSDEPENDSRowFactory
extends CatalogRowFactory {
    private static final String TABLENAME_STRING = "SYSDEPENDS";
    protected static final int SYSDEPENDS_COLUMN_COUNT = 4;
    protected static final int SYSDEPENDS_DEPENDENTID = 1;
    protected static final int SYSDEPENDS_DEPENDENTTYPE = 2;
    protected static final int SYSDEPENDS_PROVIDERID = 3;
    protected static final int SYSDEPENDS_PROVIDERTYPE = 4;
    protected static final int SYSDEPENDS_INDEX1_ID = 0;
    protected static final int SYSDEPENDS_INDEX2_ID = 1;
    private static final boolean[] uniqueness = new boolean[]{false, false};
    private static final int[][] indexColumnPositions = new int[][]{{1}, {3}};
    private static final String[] uuids = new String[]{"8000003e-00d0-fd77-3ed8-000a0a0b1900", "80000043-00d0-fd77-3ed8-000a0a0b1900", "80000040-00d0-fd77-3ed8-000a0a0b1900", "80000042-00d0-fd77-3ed8-000a0a0b1900"};

    SYSDEPENDSRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(4, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        String dependentID = null;
        DependableFinder dependentBloodhound = null;
        String providerID = null;
        DependableFinder providerBloodhound = null;
        if (td != null) {
            DependencyDescriptor dd = (DependencyDescriptor)td;
            dependentID = dd.getUUID().toString();
            dependentBloodhound = dd.getDependentFinder();
            if (dependentBloodhound == null) {
                throw StandardException.newException((String)"XD004.S", (Object[])new Object[0]);
            }
            providerID = dd.getProviderID().toString();
            providerBloodhound = dd.getProviderFinder();
            if (providerBloodhound == null) {
                throw StandardException.newException((String)"XD004.S", (Object[])new Object[0]);
            }
        }
        ExecRow row = this.getExecutionFactory().getValueRow(4);
        row.setColumn(1, new SQLChar(dependentID));
        row.setColumn(2, new UserType(dependentBloodhound));
        row.setColumn(3, new SQLChar(providerID));
        row.setColumn(4, new UserType(providerBloodhound));
        return row;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentTupleDescriptor, DataDictionary dd) throws StandardException {
        Object dependencyDesc = null;
        SanityManager.ASSERT((row.nColumns() == 4 ? 1 : 0) != 0, (String)"Wrong number of columns for a SYSDEPENDS row");
        DataValueDescriptor col = row.getColumn(1);
        String dependentIDstring = col.getString();
        UUID dependentUUID = this.getUUIDFactory().recreateUUID(dependentIDstring);
        col = row.getColumn(2);
        DependableFinder dependentBloodhound = (DependableFinder)col.getObject();
        col = row.getColumn(3);
        String providerIDstring = col.getString();
        UUID providerUUID = this.getUUIDFactory().recreateUUID(providerIDstring);
        col = row.getColumn(4);
        DependableFinder providerBloodhound = (DependableFinder)col.getObject();
        return new DependencyDescriptor(dependentUUID, dependentBloodhound, providerUUID, providerBloodhound);
    }

    @Override
    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("DEPENDENTID", false), SystemColumnImpl.getJavaColumn("DEPENDENTFINDER", "org.apache.derby.catalog.DependableFinder", false), SystemColumnImpl.getUUIDColumn("PROVIDERID", false), SystemColumnImpl.getJavaColumn("PROVIDERFINDER", "org.apache.derby.catalog.DependableFinder", false)};
    }
}

