/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jgroups.certificates;

import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.annotation.Merged;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.concurrent.BlockingManager;
import org.jboss.logging.Logger;
import org.keycloak.jgroups.certificates.ReloadCertificateFunction;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.spi.infinispan.JGroupsCertificateProvider;

@Listener
@Scope(value=Scopes.GLOBAL)
public class CertificateReloadManager
implements Lifecycle {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private static final Duration RETRY_WAIT_TIME = Duration.ofMinutes(1L);
    private static final Duration BOOT_PERIOD = Duration.ofMillis(500L);
    private final KeycloakSessionFactory sessionFactory;
    private final AutoCloseableLock lock;
    private ScheduledFuture<?> scheduledFuture;
    private ScheduledFuture<?> bootFuture;
    @Inject
    EmbeddedCacheManager cacheManager;
    @Inject
    CacheManagerNotifier notifier;
    @Inject
    BlockingManager blockingManager;
    @ComponentName(value="org.infinispan.executors.expiration")
    @Inject
    ScheduledExecutorService scheduledExecutorService;

    public CertificateReloadManager(KeycloakSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.lock = new AutoCloseableLock(new ReentrantLock());
    }

    @Start
    public void start() {
        logger.info((Object)"Starting JGroups certificate reload manager");
        this.notifier.addListener((Object)this);
        this.scheduleNextRotation();
        this.lock.lock();
        try (AutoCloseableLock autoCloseableLock = this.lock;){
            this.bootFuture = this.scheduledExecutorService.scheduleAtFixedRate(() -> this.blockingManager.runBlocking(this::bootReload, (Object)"boot-reload"), BOOT_PERIOD.toMillis(), BOOT_PERIOD.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    @Stop
    public void stop() {
        logger.info((Object)"Stopping JGroups certificate reload manager");
        this.notifier.removeListener((Object)this);
        this.lock.lock();
        try (AutoCloseableLock autoCloseableLock = this.lock;){
            if (this.scheduledFuture == null) {
                return;
            }
            this.scheduledFuture.cancel(true);
        }
    }

    public void rotateCertificate() {
        logger.info((Object)"Rotating JGroups certificate");
        this.lock.lock();
        try (AutoCloseableLock autoCloseableLock = this.lock;){
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, CertificateReloadManager::replaceCertificateInTransaction);
            this.sendReloadNotification();
        }
        catch (RuntimeException e) {
            logger.warn((Object)"Failed to rotate JGroups certificate", (Throwable)e);
            this.retry(this::rotateCertificate, "retry-rotate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadCertificate() {
        logger.info((Object)"Reloading JGroups Certificate");
        this.lock.lock();
        try (AutoCloseableLock autoCloseableLock = this.lock;){
            if (this.bootFuture != null) {
                this.bootFuture.cancel(true);
                this.bootFuture = null;
            }
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, CertificateReloadManager::loadCertificateInTransaction);
        }
        catch (RuntimeException e) {
            logger.warn((Object)"Failed to reload JGroups certificate", (Throwable)e);
            this.retry(this::reloadCertificate, "retry-reload");
        }
        finally {
            this.scheduleNextRotation();
        }
    }

    @ViewChanged
    @Merged
    public void onViewChanged(ViewChangedEvent event) {
        logger.debug((Object)"On view changed");
        this.reloadCertificate();
    }

    public boolean isCoordinator() {
        return this.cacheManager.isCoordinator();
    }

    public boolean hasRotationTask() {
        this.lock.lock();
        try (AutoCloseableLock autoCloseableLock = this.lock;){
            boolean bl = this.scheduledFuture != null;
            return bl;
        }
    }

    private void bootReload() {
        logger.debug((Object)"[Boot] reloading certificate.");
        this.lock.lock();
        try (AutoCloseableLock autoCloseableLock = this.lock;){
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, CertificateReloadManager::loadCertificateInTransaction);
        }
        catch (RuntimeException e) {
            logger.warn((Object)"Exception on boot reload cycle. Ignoring it.", (Throwable)e);
        }
    }

    private void onInvalidCertificate() {
        logger.info((Object)"On certificate exception");
        this.blockingManager.runBlocking(this::reloadCertificate, (Object)"invalid-certificate");
    }

    private void onCertificateReloadResponse(Address address, Void unused, Throwable throwable) {
        if (throwable != null) {
            logger.warnf(throwable, "Node %s failed to handle JGroups certificate reload notification.", (Object)address);
            this.retry(() -> this.sendReloadNotification(address), "retry-notification");
        }
    }

    private void scheduleNextRotation() {
        this.lock.lock();
        try (AutoCloseableLock autoCloseableLock = this.lock;){
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(false);
            }
            if (!this.isCoordinator()) {
                return;
            }
            Duration delay = (Duration)KeycloakModelUtils.runJobInTransactionWithResult((KeycloakSessionFactory)this.sessionFactory, CertificateReloadManager::nextRotationDelay);
            logger.debugf("Next rotation in %s", (Object)delay);
            if (delay.isZero()) {
                this.blockingManager.runBlocking(this::rotateCertificate, (Object)"rotate");
                return;
            }
            this.scheduledFuture = this.scheduledExecutorService.schedule(() -> this.blockingManager.runBlocking(this::rotateCertificate, (Object)"rotate"), delay.toSeconds(), TimeUnit.SECONDS);
        }
    }

    private static void replaceCertificateInTransaction(KeycloakSession session) {
        ((JGroupsCertificateProvider)session.getProvider(JGroupsCertificateProvider.class)).rotateCertificate();
    }

    private static void loadCertificateInTransaction(KeycloakSession session) {
        ((JGroupsCertificateProvider)session.getProvider(JGroupsCertificateProvider.class)).reloadCertificate();
    }

    private static Duration nextRotationDelay(KeycloakSession session) {
        return ((JGroupsCertificateProvider)session.getProvider(JGroupsCertificateProvider.class)).nextRotation();
    }

    private void sendReloadNotification() {
        this.cacheManager.executor().allNodeSubmission().submitConsumer((Function)ReloadCertificateFunction.getInstance(), this::onCertificateReloadResponse);
    }

    private void sendReloadNotification(Address destination) {
        this.cacheManager.executor().filterTargets(destination::equals).submitConsumer((Function)ReloadCertificateFunction.getInstance(), this::onCertificateReloadResponse);
    }

    private void retry(Runnable runnable, String traceId) {
        this.scheduledExecutorService.schedule(() -> this.blockingManager.runBlocking(runnable, (Object)traceId), RETRY_WAIT_TIME.toSeconds(), TimeUnit.SECONDS);
    }

    private record AutoCloseableLock(ReentrantLock innerLock) implements AutoCloseable
    {
        public void lock() {
            this.innerLock.lock();
        }

        @Override
        public void close() {
            this.innerLock.unlock();
        }
    }
}

