/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.email.prefs;

import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class EmailPrefs {
    private static final Logger LOG = Logger.getLogger("au.com.trgtd.email.prefs.EmailPrefs");
    private static final Preferences prefs = Preferences.userRoot().node("ThinkingRock/2.2.1/email");
    private static final String KEY_EMAIL_DESC = "account.descr";
    private static final String KEY_EMAIL_ADDR = "account.address";
    private static final String KEY_EMAIL_USER = "account.username";
    private static final String KEY_EMAIL_PASS = "account.password";
    private static final String KEY_EMAIL_SRVR = "email.server";
    private static final String KEY_EMAIL_PORT = "email.port";
    private static final String KEY_EMAIL_SSL = "email.ssl";
    private static final int DEF_EMAIL_PORT = 110;
    private static final boolean DEF_EMAIL_SSL = false;
    private static final String KEY_FETCH_AT_STARTUP = "fetch.at.startup";
    private static final String KEY_FETCH_SCHEDULE = "fetch.schedule";
    private static final String KEY_FETCH_MS_INTERVAL = "fetch.ms.interval";
    private static final long MS_PER_MS = 1L;
    private static final long MS_PER_SEC = 1000L;
    private static final long MS_PER_MIN = 60000L;
    private static final long MS_PER_HR = 3600000L;
    private static final long MS_PER_DAY = 86400000L;

    public static final long getDays(long ms) {
        return ms < 86400000L ? 0L : ms / 86400000L;
    }

    public static final long getHrs(long ms) {
        long remainder = ms;
        return (remainder -= EmailPrefs.getDays(ms) * 86400000L) / 3600000L;
    }

    public static final long getMins(long ms) {
        long remainder = ms;
        remainder -= EmailPrefs.getDays(ms) * 86400000L;
        return (remainder -= EmailPrefs.getHrs(ms) * 3600000L) / 60000L;
    }

    public static final long getSecs(long ms) {
        long remainder = ms;
        remainder -= EmailPrefs.getDays(ms) * 86400000L;
        remainder -= EmailPrefs.getHrs(ms) * 3600000L;
        return (remainder -= EmailPrefs.getMins(ms) * 60000L) / 1000L;
    }

    public static final long getMilliseconds(long days, long hrs, long mins, long secs) {
        return days * 86400000L + hrs * 3600000L + mins * 60000L + secs * 1000L;
    }

    public static final String getEmailDescription() {
        return prefs.get(KEY_EMAIL_DESC, "");
    }

    public static final void setEmailDescription(String value) {
        prefs.put(KEY_EMAIL_DESC, value);
        EmailPrefs.flush();
    }

    public static final String getEmailAddress() {
        return prefs.get(KEY_EMAIL_ADDR, "");
    }

    public static final void setEmailAddress(String value) {
        prefs.put(KEY_EMAIL_ADDR, value);
        EmailPrefs.flush();
    }

    public static final String getEmailUsername() {
        return prefs.get(KEY_EMAIL_USER, "");
    }

    public static final void setEmailUsername(String value) {
        prefs.put(KEY_EMAIL_USER, value);
        EmailPrefs.flush();
    }

    public static final String getEmailPassword() {
        return prefs.get(KEY_EMAIL_PASS, "");
    }

    public static final void setEmailPassword(String value) {
        prefs.put(KEY_EMAIL_PASS, value);
        EmailPrefs.flush();
    }

    public static final String getEmailServer() {
        return prefs.get(KEY_EMAIL_SRVR, "");
    }

    public static final void setEmailServer(String value) {
        prefs.put(KEY_EMAIL_SRVR, value);
        EmailPrefs.flush();
    }

    public static final int getPort() {
        return prefs.getInt(KEY_EMAIL_PORT, 110);
    }

    public static final void setPort(int value) {
        prefs.putInt(KEY_EMAIL_PORT, value);
        EmailPrefs.flush();
    }

    public static final boolean isSSL() {
        return prefs.getBoolean(KEY_EMAIL_SSL, false);
    }

    public static final void setSSL(boolean value) {
        prefs.putBoolean(KEY_EMAIL_SSL, value);
        EmailPrefs.flush();
    }

    public static final boolean isEmailFetchAtStartup() {
        return prefs.getBoolean(KEY_FETCH_AT_STARTUP, false);
    }

    public static final void setEmailFetchAtStartup(boolean value) {
        prefs.putBoolean(KEY_FETCH_AT_STARTUP, value);
        EmailPrefs.flush();
    }

    public static final boolean isEmailFetchSchedule() {
        return prefs.getBoolean(KEY_FETCH_SCHEDULE, false);
    }

    public static final void setEmailFetchSchedule(boolean value) {
        prefs.putBoolean(KEY_FETCH_SCHEDULE, value);
        EmailPrefs.flush();
    }

    public static final long getEmailFetchIntervalMS() {
        return prefs.getLong(KEY_FETCH_MS_INTERVAL, 0L);
    }

    public static final void setEmailFetchIntervalMS(long value) {
        prefs.putLong(KEY_FETCH_MS_INTERVAL, value);
        EmailPrefs.flush();
    }

    private static void flush() {
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            LOG.severe("Email preferences error. " + ex.getMessage());
        }
    }
}

