/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.AudioEffect;
import java.util.HashSet;
import java.util.Vector;

public class EffectsChain
implements AudioEffect {
    private Vector effects = new Vector();
    private HashSet enabled = new HashSet();

    public synchronized void add(AudioEffect e) {
        this.effects.add(e);
        this.enabled.add(e);
    }

    public synchronized void remove(AudioEffect e) {
        this.effects.remove(e);
        this.enabled.remove(e);
    }

    public synchronized AudioEffect remove(int i) {
        AudioEffect e = (AudioEffect)this.effects.remove(i);
        this.enabled.remove(e);
        return e;
    }

    public synchronized AudioEffect get(int i) {
        return (AudioEffect)this.effects.get(i);
    }

    public synchronized boolean contains(AudioEffect e) {
        return this.effects.contains(e);
    }

    public synchronized void enable(int i) {
        this.enabled.add(this.get(i));
    }

    public synchronized void enable(AudioEffect e) {
        if (this.effects.contains(e)) {
            this.enabled.add(e);
        }
    }

    public synchronized void enableAll() {
        this.enabled.addAll(this.effects);
    }

    public synchronized boolean hasEnabled() {
        return this.enabled.size() > 0;
    }

    public synchronized boolean isEnabled(AudioEffect e) {
        return this.enabled.contains(e);
    }

    public synchronized void disable(int i) {
        this.enabled.remove(this.get(i));
    }

    public synchronized void disable(AudioEffect e) {
        this.enabled.remove(e);
    }

    public synchronized void disableAll() {
        this.enabled.clear();
    }

    public synchronized int size() {
        return this.effects.size();
    }

    public synchronized void clear() {
        this.effects.clear();
        this.enabled.clear();
    }

    public synchronized void process(float[] samp) {
        int i = 0;
        while (i < this.effects.size()) {
            AudioEffect e = (AudioEffect)this.effects.get(i);
            if (this.enabled.contains(e)) {
                e.process(samp);
            }
            ++i;
        }
    }

    public synchronized void process(float[] sampL, float[] sampR) {
        int i = 0;
        while (i < this.effects.size()) {
            AudioEffect e = (AudioEffect)this.effects.get(i);
            if (this.enabled.contains(e)) {
                e.process(sampL, sampR);
            }
            ++i;
        }
    }
}

