/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.report.generic;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.gradle.api.internal.tasks.testing.report.generic.GenericPageRenderer;
import org.gradle.api.internal.tasks.testing.report.generic.MetadataRendererRegistry;
import org.gradle.api.internal.tasks.testing.report.generic.TestTreeModel;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableFailure;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResult;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResultStore;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializedMetadata;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.html.SimpleHtmlWriter;
import org.gradle.internal.time.TimeFormatting;
import org.gradle.reporting.ReportRenderer;

public abstract class PerRootTabRenderer
extends ReportRenderer<TestTreeModel, SimpleHtmlWriter> {
    protected final int rootIndex;
    private TestTreeModel currentModel;

    public PerRootTabRenderer(int rootIndex) {
        this.rootIndex = rootIndex;
    }

    public void render(TestTreeModel model, SimpleHtmlWriter htmlWriter) throws IOException {
        this.currentModel = model;
        TestTreeModel.PerRootInfo info = model.getPerRootInfo().get(this.rootIndex);
        this.render(info, htmlWriter);
    }

    protected final TestTreeModel getCurrentModel() {
        if (this.currentModel == null) {
            throw new IllegalStateException("No model set");
        }
        return this.currentModel;
    }

    protected abstract void render(TestTreeModel.PerRootInfo var1, SimpleHtmlWriter var2) throws IOException;

    public static final class ForMetadata
    extends PerRootTabRenderer {
        private final MetadataRendererRegistry metadataRendererRegistry;

        public ForMetadata(int rootIndex, MetadataRendererRegistry metadataRendererRegistry) {
            super(rootIndex);
            this.metadataRendererRegistry = metadataRendererRegistry;
        }

        @Override
        protected void render(TestTreeModel.PerRootInfo info, SimpleHtmlWriter htmlWriter) throws IOException {
            htmlWriter.startElement("div").attribute("class", "metadata");
            this.renderMetadataTable(info, htmlWriter);
            htmlWriter.endElement();
        }

        private void renderMetadataTable(TestTreeModel.PerRootInfo info, SimpleHtmlWriter htmlWriter) throws IOException {
            htmlWriter.startElement("table");
            this.renderMetadataTableHeader(htmlWriter);
            this.renderMetadataTableBody(info.getMetadatas(), htmlWriter);
            htmlWriter.endElement();
        }

        private SimpleHtmlWriter renderMetadataTableHeader(SimpleHtmlWriter htmlWriter) throws IOException {
            htmlWriter.startElement("thead").startElement("tr").startElement("th").characters((CharSequence)"Time").endElement().startElement("th").characters((CharSequence)"Key(s)").endElement().startElement("th").characters((CharSequence)"Value(s)").endElement().endElement().endElement();
            return htmlWriter;
        }

        private SimpleHtmlWriter renderMetadataTableBody(List<SerializedMetadata> metadatas, SimpleHtmlWriter htmlWriter) throws IOException {
            htmlWriter.startElement("tbody");
            for (int metadataIdx = 0; metadataIdx < metadatas.size(); ++metadataIdx) {
                SerializedMetadata metadata = metadatas.get(metadataIdx);
                this.renderFirstMetadataElement(metadata, metadataIdx, htmlWriter);
                if (metadata.getEntries().size() <= 1) continue;
                ImmutableList additionalEntries = metadata.getEntries().subList(1, metadata.getEntries().size());
                this.renderAdditionalMetadataElements((List<SerializedMetadata.SerializedMetadataElement>)additionalEntries, metadataIdx, htmlWriter);
            }
            htmlWriter.endElement();
            return htmlWriter;
        }

        private SimpleHtmlWriter renderFirstMetadataElement(SerializedMetadata metadata, int metadataIdx, SimpleHtmlWriter htmlWriter) throws IOException {
            htmlWriter.startElement("tr").attribute("class", metadataIdx % 2 == 0 ? "even" : "odd");
            this.renderMetadataTimeCell(metadata, htmlWriter);
            this.renderMetadataKeyValueCells((SerializedMetadata.SerializedMetadataElement)metadata.getEntries().get(0), htmlWriter).endElement();
            return htmlWriter;
        }

        private SimpleHtmlWriter renderAdditionalMetadataElements(List<SerializedMetadata.SerializedMetadataElement> elements, int metadataIdx, SimpleHtmlWriter htmlWriter) throws IOException {
            for (SerializedMetadata.SerializedMetadataElement element : elements) {
                htmlWriter.startElement("tr").attribute("class", metadataIdx % 2 == 0 ? "even" : "odd");
                this.renderMetadataKeyValueCells(element, htmlWriter);
                htmlWriter.endElement();
            }
            return htmlWriter;
        }

        private SimpleHtmlWriter renderMetadataTimeCell(SerializedMetadata metadata, SimpleHtmlWriter htmlWriter) throws IOException {
            htmlWriter.startElement("td").attribute("rowspan", Integer.toString(metadata.getEntries().size())).startElement("span").attribute("class", "time").characters((CharSequence)this.formatLogTime(metadata.getLogTime())).endElement().endElement();
            return htmlWriter;
        }

        private SimpleHtmlWriter renderMetadataKeyValueCells(SerializedMetadata.SerializedMetadataElement element, SimpleHtmlWriter htmlWriter) throws IOException {
            htmlWriter.startElement("td").attribute("class", "key").characters((CharSequence)element.getKey()).endElement().startElement("td").attribute("class", "value");
            this.renderMetadataValue(element, htmlWriter).endElement();
            return htmlWriter;
        }

        private SimpleHtmlWriter renderMetadataValue(SerializedMetadata.SerializedMetadataElement element, SimpleHtmlWriter htmlWriter) throws IOException {
            MetadataRendererRegistry.MetadataRenderer renderer = this.metadataRendererRegistry.getRenderer(element.getValueType());
            try {
                return renderer.render(element.getValue(), htmlWriter);
            }
            catch (Exception e) {
                return (SimpleHtmlWriter)htmlWriter.startElement("span").attribute("class", "unrenderable").characters((CharSequence)"[error rendering value]").endElement();
            }
        }

        private String formatLogTime(long logTime) {
            Instant instant = Instant.ofEpochMilli(logTime);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS z").withZone(ZoneId.systemDefault());
            return formatter.format(instant);
        }
    }

    public static final class ForOutput
    extends PerRootTabRenderer {
        private final SerializableTestResultStore.OutputReader outputReader;
        private final TestOutputEvent.Destination destination;

        public ForOutput(int rootIndex, SerializableTestResultStore.OutputReader outputReader, TestOutputEvent.Destination destination) {
            super(rootIndex);
            this.outputReader = outputReader;
            this.destination = destination;
        }

        @Override
        protected void render(TestTreeModel.PerRootInfo info, SimpleHtmlWriter htmlWriter) throws IOException {
            htmlWriter.startElement("span").attribute("class", "code").startElement("pre").characters((CharSequence)"");
            try (Reader reader = this.outputReader.getOutput(info.getOutputId(), this.destination);){
                CharStreams.copy((Readable)reader, (Appendable)htmlWriter);
            }
            htmlWriter.endElement().endElement();
        }
    }

    public static final class ForSummary
    extends PerRootTabRenderer {
        public ForSummary(int rootIndex) {
            super(rootIndex);
        }

        @Override
        protected void render(TestTreeModel.PerRootInfo info, SimpleHtmlWriter htmlWriter) throws IOException {
            htmlWriter.startElement("div");
            ForSummary.renderSummary(info, htmlWriter, info.getResult());
            if (info.getChildren().isEmpty()) {
                ForSummary.renderLeafDetails(info, htmlWriter);
            } else {
                this.renderChildren(htmlWriter);
            }
            htmlWriter.endElement();
        }

        private static void renderSummary(TestTreeModel.PerRootInfo info, SimpleHtmlWriter htmlWriter, SerializableTestResult testResult) throws IOException {
            htmlWriter.startElement("div").attribute("class", "summary");
            htmlWriter.startElement("table");
            htmlWriter.startElement("tr");
            htmlWriter.startElement("td");
            ForSummary.renderSummaryGroup(info, htmlWriter, testResult);
            htmlWriter.endElement();
            htmlWriter.startElement("td");
            htmlWriter.startElement("div").attribute("class", "infoBox " + ForSummary.getStatusClass(testResult.getResultType()) + " successRate");
            htmlWriter.startElement("div").attribute("class", "percent").characters((CharSequence)ForSummary.getFormattedSuccessRate(info)).endElement();
            htmlWriter.startElement("p").characters((CharSequence)"successful").endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
        }

        private static void renderSummaryGroup(TestTreeModel.PerRootInfo info, SimpleHtmlWriter htmlWriter, SerializableTestResult testResult) throws IOException {
            htmlWriter.startElement("div").attribute("class", "summaryGroup");
            htmlWriter.startElement("table");
            htmlWriter.startElement("tr");
            htmlWriter.startElement("td");
            htmlWriter.startElement("div").attribute("class", "infoBox");
            htmlWriter.startElement("div").attribute("class", "counter").characters((CharSequence)Integer.toString(info.getTotalLeafCount())).endElement();
            htmlWriter.startElement("p").characters((CharSequence)"tests").endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
            htmlWriter.startElement("td");
            htmlWriter.startElement("div").attribute("class", "infoBox");
            htmlWriter.startElement("div").attribute("class", "counter").characters((CharSequence)Integer.toString(info.getFailedLeafCount())).endElement();
            htmlWriter.startElement("p").characters((CharSequence)"failures").endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
            htmlWriter.startElement("td");
            htmlWriter.startElement("div").attribute("class", "infoBox");
            htmlWriter.startElement("div").attribute("class", "counter").characters((CharSequence)Integer.toString(info.getSkippedLeafCount())).endElement();
            htmlWriter.startElement("p").characters((CharSequence)"skipped").endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
            htmlWriter.startElement("td");
            htmlWriter.startElement("div").attribute("class", "infoBox duration");
            htmlWriter.startElement("div").attribute("class", "counter").characters((CharSequence)ForSummary.getFormattedDuration(testResult)).endElement();
            htmlWriter.startElement("p").characters((CharSequence)"duration").endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
        }

        private static String getFormattedDuration(SerializableTestResult testResult) {
            return TimeFormatting.formatDurationVeryTerse((long)testResult.getDuration());
        }

        private static void renderLeafDetails(TestTreeModel.PerRootInfo info, SimpleHtmlWriter htmlWriter) throws IOException {
            if (info.getResult().getResultType() != TestResult.ResultType.SUCCESS && !info.getResult().getFailures().isEmpty()) {
                htmlWriter.startElement("div").attribute("class", "result-details");
                htmlWriter.startElement("h3").characters((CharSequence)(info.getResult().getResultType() == TestResult.ResultType.FAILURE ? "Failure details" : "Skip details")).endElement();
                htmlWriter.startElement("span").attribute("class", "code").startElement("pre").characters((CharSequence)"");
                for (SerializableFailure failure : info.getResult().getFailures()) {
                    htmlWriter.characters((CharSequence)(failure.getStackTrace() + "\n"));
                }
                htmlWriter.endElement().endElement();
                htmlWriter.endElement();
            }
        }

        private void renderChildren(SimpleHtmlWriter htmlWriter) throws IOException {
            htmlWriter.startElement("table");
            htmlWriter.startElement("thead");
            htmlWriter.startElement("tr");
            boolean anyNameAndDisplayNameDiffer = Iterables.any(this.getCurrentModel().getChildrenOf(this.rootIndex), child -> {
                SerializableTestResult childResult = child.getPerRootInfo().get(this.rootIndex).getResult();
                return !childResult.getName().equals(childResult.getDisplayName());
            });
            htmlWriter.startElement("th").characters((CharSequence)"Child").endElement();
            if (anyNameAndDisplayNameDiffer) {
                htmlWriter.startElement("th").characters((CharSequence)"Name").endElement();
            }
            htmlWriter.startElement("th").characters((CharSequence)"Tests").endElement();
            htmlWriter.startElement("th").characters((CharSequence)"Failures").endElement();
            htmlWriter.startElement("th").characters((CharSequence)"Skipped").endElement();
            htmlWriter.startElement("th").characters((CharSequence)"Duration").endElement();
            htmlWriter.startElement("th").characters((CharSequence)"Success rate").endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
            for (TestTreeModel child2 : this.getCurrentModel().getChildrenOf(this.rootIndex)) {
                TestTreeModel.PerRootInfo perRootInfo = child2.getPerRootInfo().get(this.rootIndex);
                SerializableTestResult result = perRootInfo.getResult();
                String statusClass = ForSummary.getStatusClass(result.getResultType());
                htmlWriter.startElement("tr");
                htmlWriter.startElement("td").attribute("class", statusClass);
                htmlWriter.startElement("a").attribute("href", GenericPageRenderer.getUrlTo(this.getCurrentModel().getPath(), child2.getPath())).characters((CharSequence)result.getDisplayName()).endElement();
                if (anyNameAndDisplayNameDiffer) {
                    htmlWriter.startElement("td").characters((CharSequence)result.getName()).endElement();
                }
                htmlWriter.endElement();
                htmlWriter.startElement("td").characters((CharSequence)Integer.toString(perRootInfo.getTotalLeafCount())).endElement();
                htmlWriter.startElement("td").characters((CharSequence)Integer.toString(perRootInfo.getFailedLeafCount())).endElement();
                htmlWriter.startElement("td").characters((CharSequence)Integer.toString(perRootInfo.getSkippedLeafCount())).endElement();
                htmlWriter.startElement("td").characters((CharSequence)ForSummary.getFormattedDuration(result)).endElement();
                htmlWriter.startElement("td").attribute("class", statusClass).characters((CharSequence)ForSummary.getFormattedSuccessRate(perRootInfo)).endElement();
                htmlWriter.endElement();
            }
            htmlWriter.endElement();
        }

        private static String getStatusClass(TestResult.ResultType resultType) {
            switch (resultType) {
                case SUCCESS: {
                    return "success";
                }
                case FAILURE: {
                    return "failures";
                }
                case SKIPPED: {
                    return "skipped";
                }
            }
            throw new IllegalStateException();
        }

        private static String getFormattedSuccessRate(TestTreeModel.PerRootInfo info) {
            if (info.getTotalLeafCount() == 0) {
                return "-";
            }
            BigDecimal runTests = BigDecimal.valueOf(info.getTotalLeafCount());
            BigDecimal successful = BigDecimal.valueOf(info.getTotalLeafCount() - info.getFailedLeafCount());
            return successful.divide(runTests, 2, RoundingMode.DOWN).multiply(BigDecimal.valueOf(100L)).intValue() + "%";
        }
    }
}

