/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class AssociateDhcpOptions
extends BaseCmd {
    private static final String[] VPC_DESC = new String[]{"The ID of the VPC you want to associate the DHCP options with."};
    private String vpcId;
    private String dhcpOptionId;

    public AssociateDhcpOptions(String[] args) {
        super("ec2assocdopt", "ec2-associate-dhcp-options");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    protected String getOptionString() {
        return "{ DHCP_OPTIONS | default } -c VPC";
    }

    private Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"vpc");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"VPC");
        OptionBuilder.withDescription((String)AssociateDhcpOptions.joinDescription(VPC_DESC));
        options.addOption(OptionBuilder.create((String)"c"));
        return options;
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Associates a set of DHCP options that you've previously created with the");
        System.out.println("     specified VPC. The DHCP_OPTIONS parameter is the DHCP options you want to");
        System.out.println("     associate with the VPC, or \"default\", to associate the default DHCP");
        System.out.println("     options.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("vpc");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        this.dhcpOptionId = this.getNonOptions()[0];
        this.vpcId = this.getOptionValue("vpc");
        RequestResultPair rsp = jec2.associateDhcpOptions(this.vpcId, this.dhcpOptionId);
        out.outputAssociateDhcpWithVpc(System.out, this.vpcId, this.dhcpOptionId);
        out.printRequestId(System.out, (RequestResult)rsp);
        return (Boolean)rsp.getResponse();
    }

    @Override
    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    protected void validateParameters() {
        this.assertNonOptionSet("DHCP_OPTIONS");
        this.warnIfTooManyNonOptions();
        this.assertOptionSet("vpc");
    }

    public static void main(String[] args) {
        new AssociateDhcpOptions(args).invoke();
    }
}

