/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap;

import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.architect.olap.OLAPUtil;
import ca.sqlpower.architect.swingui.ContainerPane;
import ca.sqlpower.architect.swingui.ContainerPaneUI;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.PlayPenCoordinate;
import ca.sqlpower.architect.swingui.olap.OLAPPane;
import ca.sqlpower.architect.swingui.olap.OSUtils;
import ca.sqlpower.architect.swingui.olap.PaneSection;
import ca.sqlpower.object.AbstractSPListener;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.util.SQLPowerUtils;
import ca.sqlpower.util.TransactionEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.beans.PropertyChangeEvent;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public abstract class OLAPPaneUI<T extends OLAPObject, C extends OLAPObject>
extends ContainerPaneUI {
    private static final Logger logger = Logger.getLogger(OLAPPaneUI.class);
    private static final int BOX_LINE_THICKNESS = 1;
    private static final int GAP = 1;
    private static final int INTER_SECTION_GAP = 9;
    private static final int ARC_LENGTH = 10;
    private static final BasicStroke DASHED_STROKE = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{15.0f, 4.0f}, 0.0f);
    private static final BasicStroke NORMAL_STROKE = new BasicStroke(1.0f);
    private static final int MINIMUM_WIDTH = 100;
    private static final int SECTION_HEADER_VGAP = 5;
    private static final int ICON_TITLE_HGAP = 5;
    private Color selectedColor = new Color(204, 204, 255);
    protected OLAPPane<T, C> olapPane;
    protected final ModelEventHandler modelEventHandler = new ModelEventHandler();
    protected final PaneEventHandler paneEventHandler = new PaneEventHandler();

    @Override
    public Dimension getPreferredSize() {
        OLAPPane<T, C> cp = this.olapPane;
        int height = 0;
        int width = 0;
        Font font = cp.getFont();
        if (font == null) {
            logger.error((Object)"getPreferredSize(): ContainerPane is missing font.");
            return null;
        }
        FontMetrics metrics = cp.getFontMetrics(font);
        int fontHeight = metrics.getHeight();
        height += fontHeight + 1 + 1;
        for (PaneSection<C> ps : this.olapPane.getSections()) {
            if (ps.getTitle() != null) {
                height += fontHeight + 5;
            }
            height += ps.getItems().size() * fontHeight;
        }
        height += 9 * (this.olapPane.getSections().size() - 1);
        if (++height < fontHeight * 3) {
            height = fontHeight * 3;
        }
        width = 100;
        width = Math.max(width, this.calculateTextWidth(cp, ((PlayPenComponent)cp).getModelName()) + OSUtils.iconFor((OLAPObject)((Object)this.olapPane.getModel())).getIconWidth() + 5);
        for (PaneSection<C> ps : this.olapPane.getSections()) {
            width = Math.max(width, this.calculateMaxSectionWidth(ps, cp));
        }
        Insets insets = cp.getMargin();
        return new Dimension(width += insets.left + cp.getMargin().left + 2 + cp.getMargin().right + insets.right, height);
    }

    @Override
    public void installUI(PlayPenComponent c) {
        this.olapPane = (OLAPPane)c;
        SQLPowerUtils.listenToHierarchy((SPObject)((SPObject)this.olapPane.getModel()), (SPListener)this.modelEventHandler);
        this.olapPane.addSPListener((SPListener)this.paneEventHandler);
    }

    @Override
    public void uninstallUI(PlayPenComponent c) {
        SQLPowerUtils.unlistenToHierarchy((SPObject)((SPObject)this.olapPane.getModel()), (SPListener)this.modelEventHandler);
        this.olapPane.removeSPListener((SPListener)this.paneEventHandler);
    }

    @Override
    public void paint(Graphics2D g2) {
        g2 = (Graphics2D)g2.create();
        OLAPPane<T, C> op = this.olapPane;
        Stroke oldStroke = g2.getStroke();
        if (op.isDashed()) {
            g2.setStroke(DASHED_STROKE);
        } else {
            g2.setStroke(NORMAL_STROKE);
        }
        if (logger.isDebugEnabled()) {
            Rectangle clip = g2.getClipBounds();
            if (clip != null) {
                g2.setColor(Color.RED);
                --clip.width;
                --clip.height;
                g2.draw(clip);
                g2.setColor(op.getForegroundColor());
                logger.debug((Object)("Clipping region: " + g2.getClip()));
            } else {
                logger.debug((Object)"Null clipping region");
            }
        }
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, op.getWidth(), op.getHeight());
        int width = op.getWidth() - 1;
        int height = op.getHeight();
        Font font = op.getFont();
        if (font == null) {
            return;
        }
        FontMetrics metrics = op.getFontMetrics(font);
        int fontHeight = metrics.getHeight();
        int ascent = metrics.getAscent();
        int y = 0;
        g2.setColor(op.getPlayPen().getBackground());
        g2.fillRect(0, 0, width, height);
        if (op.isSelected()) {
            g2.setColor(op.getBackgroundColor().darker());
        } else {
            g2.setColor(op.getBackgroundColor());
        }
        if (op.isRounded()) {
            g2.fillRoundRect(0, 0, width, fontHeight, 10, 10);
        } else {
            g2.fillRect(0, 0, width, fontHeight);
        }
        g2.setColor(op.getForegroundColor());
        Icon icon = OSUtils.iconFor((OLAPObject)((Object)op.getModel()));
        icon.paintIcon(null, g2, 0, 0);
        g2.drawString(((OLAPObject)((Object)op.getModel())).getName(), icon.getIconWidth() + 5, y += ascent);
        g2.setColor(Color.BLACK);
        y += 2;
        boolean firstSection = true;
        for (PaneSection<C> ps : this.olapPane.getSections()) {
            if (!firstSection) {
                g2.drawLine(0, y + (9 + fontHeight - ascent) / 2, width, y + (9 + fontHeight - ascent) / 2);
                y += 9;
            }
            y = this.drawSection(ps, g2, op, y);
            firstSection = false;
        }
        g2.setColor(Color.BLACK);
        if (op.isRounded()) {
            g2.drawRoundRect(0, fontHeight + 1, width, height - (fontHeight + 1 + 1), 10, 10);
        } else {
            g2.drawRect(0, fontHeight + 1, width, height - (fontHeight + 1 + 1));
        }
        g2.setStroke(oldStroke);
    }

    @Override
    public boolean contains(Point p) {
        return this.olapPane.getBounds().contains(p);
    }

    @Override
    public void revalidate() {
        this.olapPane.setSize(this.getPreferredSize());
    }

    public PaneSection<? extends C> toSectionLocation(Point point, boolean editPoint) {
        Point p = editPoint ? point : new Point(point);
        Font font = this.olapPane.getFont();
        FontMetrics metrics = this.olapPane.getFontMetrics(font);
        int fontHeight = metrics.getHeight();
        int ascent = metrics.getAscent();
        logger.debug((Object)("SECLOC: searching for section location of y=" + p.y));
        if (p.y <= fontHeight) {
            logger.debug((Object)("y<=fontHeight = " + fontHeight));
            logger.debug((Object)"SECLOC: it's in the title");
            return null;
        }
        int translatedY = p.y - fontHeight;
        logger.debug((Object)("SECLOC: looking through sections; translatedY=" + translatedY));
        boolean firstSection = true;
        for (PaneSection<C> sect : this.olapPane.getSections()) {
            int sectionHeight = fontHeight * sect.getItems().size();
            if (sect.getTitle() != null) {
                sectionHeight += fontHeight + 5;
            }
            if (firstSection) {
                sectionHeight += (9 + fontHeight - ascent) / 2;
                firstSection = false;
            } else {
                sectionHeight += 9;
            }
            if (translatedY < sectionHeight) {
                p.y = translatedY;
                return sect;
            }
            translatedY -= sectionHeight;
        }
        return null;
    }

    @Override
    @Deprecated
    public int pointToItemIndex(Point p) {
        int returnVal;
        p = new Point(p);
        Font font = this.olapPane.getFont();
        FontMetrics metrics = this.olapPane.getFontMetrics(font);
        int fontHeight = metrics.getHeight();
        int descent = metrics.getDescent();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("p.y = " + p.y + "; fontHeight = " + fontHeight + "; descent = " + descent));
        }
        if (p.y < 0) {
            logger.debug((Object)"y<0");
            returnVal = -2;
        } else if (p.y <= fontHeight) {
            logger.debug((Object)("y<=fontHeight = " + fontHeight));
            returnVal = -1;
        } else {
            PaneSection<C> sect = this.toSectionLocation(p, true);
            if (sect != null) {
                returnVal = this.firstItemIndex(sect);
                logger.debug((Object)("Y is: " + p.y + " In section: " + sect.getTitle() + " and right now returnVal is: " + returnVal));
                int adjustment = -descent;
                if (sect != this.olapPane.getSections().get(0)) {
                    adjustment -= 4;
                }
                if (sect.getTitle() != null) {
                    if (p.y <= fontHeight + 5) {
                        return -3;
                    }
                    int sectTitleHeight = fontHeight + 5;
                    adjustment -= sectTitleHeight;
                }
                returnVal += (p.y + adjustment) / fontHeight;
            } else {
                returnVal = -2;
            }
        }
        logger.debug((Object)("pointToItemIndex return value is " + returnVal));
        return returnVal;
    }

    public PlayPenCoordinate<T, C> pointToPPCoordinate(Point p) {
        OLAPObject item;
        PaneSection<C> sect;
        int index;
        p = new Point(p);
        Font font = this.olapPane.getFont();
        FontMetrics metrics = this.olapPane.getFontMetrics(font);
        int fontHeight = metrics.getHeight();
        int descent = metrics.getDescent();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("p.y = " + p.y + "; fontHeight = " + fontHeight + "; descent = " + descent));
        }
        if (p.y < 0) {
            logger.debug((Object)"y<0");
            index = -2;
            sect = null;
            item = null;
        } else if (p.y <= fontHeight) {
            logger.debug((Object)("y<=fontHeight = " + fontHeight));
            index = -1;
            sect = null;
            item = null;
        } else if (this.toSectionLocation(p, false) != null) {
            sect = this.toSectionLocation(p, true);
            logger.debug((Object)("Y is: " + p.y + " In section: " + sect.getTitle()));
            int adjustment = -descent;
            if (sect != this.olapPane.getSections().get(0)) {
                adjustment -= 4;
            }
            if (sect.getTitle() != null) {
                if (p.y <= fontHeight + 5) {
                    PlayPenCoordinate<T, Object> returnVal = new PlayPenCoordinate<T, Object>(this.olapPane, sect, -3, null);
                    logger.debug((Object)("pointToPPCoordinate returnVal is: " + returnVal));
                    return returnVal;
                }
                int sectTitleHeight = fontHeight + 5;
                adjustment -= sectTitleHeight;
            }
            if ((index = (p.y + adjustment) / fontHeight) >= sect.getItems().size()) {
                index = -2;
                item = null;
            } else {
                item = (OLAPObject)((Object)sect.getItems().get(index));
            }
        } else {
            index = -2;
            sect = null;
            item = null;
        }
        PlayPenCoordinate<T, Object> returnVal = new PlayPenCoordinate<T, Object>(this.olapPane, (PaneSection<Object>)sect, index, item);
        logger.debug((Object)("pointToPPCoordinate returnVal is: " + returnVal));
        return returnVal;
    }

    public int firstItemIndex(PaneSection<? extends C> sect) {
        int index = 0;
        for (PaneSection<C> s : this.olapPane.getSections()) {
            if (sect == s) {
                return index;
            }
            index += s.getItems().size();
        }
        throw new IllegalArgumentException("Given section is not part of this OLAP Pane");
    }

    private int drawSection(PaneSection<? extends C> ps, Graphics2D g, OLAPPane<T, C> cp, int startY) {
        PlayPenCoordinate<T, C> insertionPoint = this.olapPane.getInsertionPoint();
        if (insertionPoint == null || insertionPoint.getSection() != ps) {
            insertionPoint = null;
        }
        int width = cp.getWidth() - cp.getInsets().left - cp.getInsets().right;
        FontMetrics metrics = cp.getFontMetrics(cp.getFont());
        int fontHeight = metrics.getHeight();
        int ascent = metrics.getAscent();
        int insertionPointAdjustment = metrics.getDescent();
        int y = startY;
        int hwidth = width - cp.getMargin().right - cp.getMargin().left - 2;
        g.setColor(cp.getForegroundColor());
        if (ps.getTitle() != null) {
            if (cp.isSectionSelected(ps)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Section " + ps.getTitle() + " is selected"));
                }
                g.setColor(this.selectedColor);
                g.fillRect(1 + cp.getMargin().left, y - ascent + fontHeight, hwidth, fontHeight);
                g.setColor(cp.getForegroundColor());
            }
            g.drawString(ps.getTitle(), 1, y += fontHeight);
            y += 5;
        }
        if (insertionPoint != null && insertionPoint.getIndex() == -3) {
            this.paintInsertionPoint(g, y + insertionPointAdjustment, hwidth);
        }
        int i = 0;
        for (OLAPObject item : ps.getItems()) {
            String itemName;
            if (cp.isItemSelected(item)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Item " + i + " is selected"));
                }
                g.setColor(this.selectedColor);
                g.fillRect(1 + cp.getMargin().left, y - ascent + fontHeight, hwidth, fontHeight);
                g.setColor(cp.getForegroundColor());
            }
            if (insertionPoint != null && insertionPoint.getIndex() == i) {
                this.paintInsertionPoint(g, y + insertionPointAdjustment, hwidth);
            }
            g.drawString((itemName = OLAPUtil.nameFor(item)) == null ? "(null)" : itemName, 1 + cp.getMargin().left, y += fontHeight);
            ++i;
        }
        if (insertionPoint != null && insertionPoint.getIndex() == i) {
            this.paintInsertionPoint(g, y + insertionPointAdjustment, hwidth);
        }
        return y;
    }

    private int calculateTextWidth(PlayPenComponent ppc, String text) {
        Font font = ppc.getFont();
        FontRenderContext frc = ppc.getFontRenderContext();
        FontMetrics metrics = ppc.getFontMetrics(font);
        if (text == null) {
            text = "(null!?)";
        }
        if (frc == null) {
            return metrics.stringWidth(text);
        }
        return (int)font.getStringBounds(text, frc).getWidth();
    }

    private int calculateMaxSectionWidth(PaneSection<? extends C> ps, ContainerPane<?, ?> cp) {
        int width = this.calculateTextWidth(cp, ps.getTitle());
        for (OLAPObject oo : ps.getItems()) {
            if (oo == null) {
                logger.error((Object)("Found null column in dimension '" + cp.getName() + "'"));
                throw new NullPointerException("Found null column in dimension '" + cp.getName() + "'");
            }
            width = Math.max(width, this.calculateTextWidth(cp, OLAPUtil.nameFor(oo)));
        }
        return width;
    }

    @Override
    public Point getPointForModelObject(Object modelObject) {
        return this.olapPane.getLocation();
    }

    private class PaneEventHandler
    extends AbstractSPListener {
        private PaneEventHandler() {
        }

        public void propertyChanged(PropertyChangeEvent evt) {
            if ("insertionPoint".equals(evt.getPropertyName())) {
                OLAPPaneUI.this.olapPane.repaint();
            }
        }
    }

    private class ModelEventHandler
    implements SPListener {
        private ModelEventHandler() {
        }

        public void propertyChanged(PropertyChangeEvent evt) {
            logger.debug((Object)("Property Change: " + evt.getPropertyName() + ": " + evt.getOldValue() + " -> " + evt.getNewValue()));
            if ("name".equals(evt.getPropertyName()) || "cubeName".equals(evt.getPropertyName())) {
                OLAPPaneUI.this.olapPane.revalidate();
            }
        }

        public void childAdded(SPChildEvent e) {
            SQLPowerUtils.listenToHierarchy((SPObject)e.getChild(), (SPListener)this);
            OLAPPaneUI.this.olapPane.revalidate();
        }

        public void childRemoved(SPChildEvent e) {
            SQLPowerUtils.unlistenToHierarchy((SPObject)e.getChild(), (SPListener)this);
            OLAPPaneUI.this.olapPane.revalidate();
        }

        public void transactionEnded(TransactionEvent e) {
        }

        public void transactionRollback(TransactionEvent e) {
        }

        public void transactionStarted(TransactionEvent e) {
        }
    }
}

