/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * min(uvec2(0u, 0u), uvec2(0u, 1u)) => uvec2(0u, 0u)
 * min(uvec2(0u, 0u), uvec2(2u, 5u)) => uvec2(0u, 0u)
 * min(uvec2(0u, 1u), uvec2(34u, 0u)) => uvec2(0u, 0u)
 * min(uvec2(1u, 1u), uvec2(1u, 2u)) => uvec2(1u, 1u)
 * min(uvec2(1u, 1u), uvec2(5u, 34u)) => uvec2(1u, 1u)
 * min(uvec2(2u, 2u), uvec2(0u, 1u)) => uvec2(0u, 1u)
 * min(uvec2(2u, 2u), uvec2(2u, 5u)) => uvec2(2u, 2u)
 * min(uvec2(2u, 5u), uvec2(34u, 0u)) => uvec2(2u, 0u)
 * min(uvec2(5u, 5u), uvec2(1u, 2u)) => uvec2(1u, 2u)
 * min(uvec2(5u, 5u), uvec2(5u, 34u)) => uvec2(5u, 5u)
 * min(uvec2(34u, 34u), uvec2(0u, 1u)) => uvec2(0u, 1u)
 * min(uvec2(34u, 34u), uvec2(2u, 5u)) => uvec2(2u, 5u)
 * min(uvec2(34u, 0u), uvec2(34u, 0u)) => uvec2(34u, 0u)
 */
#version 150

void main()
{
  float[all(equal(min(uvec2(0u, 0u), uvec2(0u, 1u)), uvec2(0u, 0u))) ? 1 : -1] array0;
  float[all(equal(min(uvec2(0u, 0u), uvec2(2u, 5u)), uvec2(0u, 0u))) ? 1 : -1] array1;
  float[all(equal(min(uvec2(0u, 1u), uvec2(34u, 0u)), uvec2(0u, 0u))) ? 1 : -1] array2;
  float[all(equal(min(uvec2(1u, 1u), uvec2(1u, 2u)), uvec2(1u, 1u))) ? 1 : -1] array3;
  float[all(equal(min(uvec2(1u, 1u), uvec2(5u, 34u)), uvec2(1u, 1u))) ? 1 : -1] array4;
  float[all(equal(min(uvec2(2u, 2u), uvec2(0u, 1u)), uvec2(0u, 1u))) ? 1 : -1] array5;
  float[all(equal(min(uvec2(2u, 2u), uvec2(2u, 5u)), uvec2(2u, 2u))) ? 1 : -1] array6;
  float[all(equal(min(uvec2(2u, 5u), uvec2(34u, 0u)), uvec2(2u, 0u))) ? 1 : -1] array7;
  float[all(equal(min(uvec2(5u, 5u), uvec2(1u, 2u)), uvec2(1u, 2u))) ? 1 : -1] array8;
  float[all(equal(min(uvec2(5u, 5u), uvec2(5u, 34u)), uvec2(5u, 5u))) ? 1 : -1] array9;
  float[all(equal(min(uvec2(34u, 34u), uvec2(0u, 1u)), uvec2(0u, 1u))) ? 1 : -1] array10;
  float[all(equal(min(uvec2(34u, 34u), uvec2(2u, 5u)), uvec2(2u, 5u))) ? 1 : -1] array11;
  float[all(equal(min(uvec2(34u, 0u), uvec2(34u, 0u)), uvec2(34u, 0u))) ? 1 : -1] array12;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length());
}
