/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0l % 3l) => 0l
 * (0l % 1048576l) => 0l
 * (0l % 4251475l) => 0l
 * (0l % 29852643761l) => 0l
 * (3l % 3l) => 0l
 * (3l % 1048576l) => 3l
 * (3l % 4251475l) => 3l
 * (3l % 29852643761l) => 3l
 * (1048576l % 3l) => 1l
 * (1048576l % 1048576l) => 0l
 * (1048576l % 4251475l) => 1048576l
 * (1048576l % 29852643761l) => 1048576l
 * (4251475l % 3l) => 1l
 * (4251475l % 1048576l) => 57171l
 * (4251475l % 4251475l) => 0l
 * (4251475l % 29852643761l) => 4251475l
 * (29852643761l % 3l) => 2l
 * (29852643761l % 1048576l) => 733617l
 * (29852643761l % 4251475l) => 3037786l
 * (29852643761l % 29852643761l) => 0l
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[(0l % 3l) == 0l ? 1 : -1] array0;
  float[(0l % 1048576l) == 0l ? 1 : -1] array1;
  float[(0l % 4251475l) == 0l ? 1 : -1] array2;
  float[(0l % 29852643761l) == 0l ? 1 : -1] array3;
  float[(3l % 3l) == 0l ? 1 : -1] array4;
  float[(3l % 1048576l) == 3l ? 1 : -1] array5;
  float[(3l % 4251475l) == 3l ? 1 : -1] array6;
  float[(3l % 29852643761l) == 3l ? 1 : -1] array7;
  float[(1048576l % 3l) == 1l ? 1 : -1] array8;
  float[(1048576l % 1048576l) == 0l ? 1 : -1] array9;
  float[(1048576l % 4251475l) == 1048576l ? 1 : -1] array10;
  float[(1048576l % 29852643761l) == 1048576l ? 1 : -1] array11;
  float[(4251475l % 3l) == 1l ? 1 : -1] array12;
  float[(4251475l % 1048576l) == 57171l ? 1 : -1] array13;
  float[(4251475l % 4251475l) == 0l ? 1 : -1] array14;
  float[(4251475l % 29852643761l) == 4251475l ? 1 : -1] array15;
  float[(29852643761l % 3l) == 2l ? 1 : -1] array16;
  float[(29852643761l % 1048576l) == 733617l ? 1 : -1] array17;
  float[(29852643761l % 4251475l) == 3037786l ? 1 : -1] array18;
  float[(29852643761l % 29852643761l) == 0l ? 1 : -1] array19;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
