/*
 * Decompiled with CFR 0.152.
 */
package lucee.cli;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public class MainEntryPoint {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Throwable {
        File[] children;
        File libDir = new File("./").getCanonicalFile();
        System.out.println(libDir);
        if (libDir.getName().equals(".") || libDir.getName().equals("..")) {
            libDir = libDir.getParentFile();
        }
        if ((children = libDir.listFiles(new ExtFilter())).length < 2) {
            libDir = new File(libDir, "lib");
            children = libDir.listFiles(new ExtFilter());
        }
        URL[] urls = new URL[children.length];
        System.out.println("Loading Jars");
        for (int i = 0; i < children.length; ++i) {
            urls[i] = new URL("jar:file://" + children[i] + "!/");
            System.out.println("- " + urls[i]);
        }
        System.out.println();
        URLClassLoader cl = null;
        try {
            cl = new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
            Class<?> cli = cl.loadClass("lucee.cli.CLI");
            Method main = cli.getMethod("main", String[].class);
            main.invoke(null, new Object[]{args});
        }
        finally {
            if (cl != null) {
                try {
                    cl.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static class ExtFilter
    implements FilenameFilter {
        private final String ext = ".jar";

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".jar");
        }
    }
}

