/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.plugin;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;

public class PluginUpdatePolicyPanel
extends JPanel {
    private transient Map<Policy, JRadioButton> rbVersionBasedUpatePolicy;
    private transient Map<Policy, JRadioButton> rbTimeBasedUpatePolicy;
    private final JosmTextField tfUpdateInterval = new JosmTextField(5);
    private final JLabel lblUpdateInterval = new JLabel(I18n.tr("Update interval (in days):", new Object[0]));

    public PluginUpdatePolicyPanel() {
        this.build();
        this.initFromPreferences();
    }

    protected JPanel buildVersionBasedUpdatePolicyPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        ButtonGroup bgVersionBasedUpdatePolicy = new ButtonGroup();
        this.rbVersionBasedUpatePolicy = new EnumMap<Policy, JRadioButton>(Policy.class);
        JRadioButton btn = new JRadioButton(I18n.tr("Ask before updating", new Object[0]));
        this.rbVersionBasedUpatePolicy.put(Policy.ASK, btn);
        bgVersionBasedUpdatePolicy.add(btn);
        btn = new JRadioButton(I18n.tr("Always update without asking", new Object[0]));
        this.rbVersionBasedUpatePolicy.put(Policy.ALWAYS, btn);
        bgVersionBasedUpdatePolicy.add(btn);
        btn = new JRadioButton(I18n.tr("Never update", new Object[0]));
        this.rbVersionBasedUpatePolicy.put(Policy.NEVER, btn);
        bgVersionBasedUpdatePolicy.add(btn);
        JMultilineLabel lbl = new JMultilineLabel(I18n.tr("Please decide whether JOSM shall automatically update active plugins at startup after an update of JOSM itself.", new Object[0]));
        gc.gridy = 0;
        pnl.add((Component)lbl, gc);
        for (Policy p : Policy.values()) {
            ++gc.gridy;
            pnl.add((Component)this.rbVersionBasedUpatePolicy.get((Object)p), gc);
        }
        return pnl;
    }

    protected JPanel buildUpdateIntervalPanel() {
        JPanel pnl = new JPanel(new FlowLayout(0));
        pnl.add(this.lblUpdateInterval);
        pnl.add(this.tfUpdateInterval);
        this.lblUpdateInterval.setLabelFor(this.tfUpdateInterval);
        SelectAllOnFocusGainedDecorator.decorate(this.tfUpdateInterval);
        return pnl;
    }

    protected JPanel buildTimeBasedUpdatePolicyPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        TimeBasedPolicyChangeListener changeListener = new TimeBasedPolicyChangeListener();
        ButtonGroup bgTimeBasedUpdatePolicy = new ButtonGroup();
        this.rbTimeBasedUpatePolicy = new EnumMap<Policy, JRadioButton>(Policy.class);
        JRadioButton btn = new JRadioButton(I18n.tr("Ask before updating", new Object[0]));
        btn.addChangeListener(changeListener);
        this.rbTimeBasedUpatePolicy.put(Policy.ASK, btn);
        bgTimeBasedUpdatePolicy.add(btn);
        btn = new JRadioButton(I18n.tr("Always update without asking", new Object[0]));
        btn.addChangeListener(changeListener);
        this.rbTimeBasedUpatePolicy.put(Policy.ALWAYS, btn);
        bgTimeBasedUpdatePolicy.add(btn);
        btn = new JRadioButton(I18n.tr("Never update", new Object[0]));
        btn.addChangeListener(changeListener);
        this.rbTimeBasedUpatePolicy.put(Policy.NEVER, btn);
        bgTimeBasedUpdatePolicy.add(btn);
        JMultilineLabel lbl = new JMultilineLabel(I18n.tr("Please decide whether JOSM shall automatically update active plugins after a certain period of time.", new Object[0]));
        gc.gridy = 0;
        pnl.add((Component)lbl, gc);
        for (Policy p : Policy.values()) {
            ++gc.gridy;
            pnl.add((Component)this.rbTimeBasedUpatePolicy.get((Object)p), gc);
        }
        ++gc.gridy;
        pnl.add((Component)this.buildUpdateIntervalPanel(), gc);
        return pnl;
    }

    protected final void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.insets = new Insets(5, 5, 10, 5);
        this.add((Component)this.buildVersionBasedUpdatePolicyPanel(), gc);
        gc.gridy = 1;
        this.add((Component)this.buildTimeBasedUpdatePolicyPanel(), gc);
        gc.gridy = 2;
        gc.weighty = 1.0;
        gc.fill = 1;
        this.add((Component)new JPanel(), gc);
    }

    public final void initFromPreferences() {
        this.rbVersionBasedUpatePolicy.get((Object)Optional.ofNullable(Policy.fromPreferenceValue(Config.getPref().get("pluginmanager.version-based-update.policy", "ask"))).orElse(Policy.ASK)).setSelected(true);
        this.rbTimeBasedUpatePolicy.get((Object)Optional.ofNullable(Policy.fromPreferenceValue(Config.getPref().get("pluginmanager.time-based-update.policy", "ask"))).orElse(Policy.ASK)).setSelected(true);
        int days = Config.getPref().getInt("pluginmanager.time-based-update.interval", 30);
        this.tfUpdateInterval.setText(Integer.toString(days));
    }

    public void rememberInPreferences() {
        for (Policy p : Policy.values()) {
            if (!this.rbVersionBasedUpatePolicy.get((Object)p).isSelected()) continue;
            Config.getPref().put("pluginmanager.version-based-update.policy", p.getPreferencesValue());
            break;
        }
        for (Policy p : Policy.values()) {
            if (!this.rbTimeBasedUpatePolicy.get((Object)p).isSelected()) continue;
            Config.getPref().put("pluginmanager.time-based-update.policy", p.getPreferencesValue());
            break;
        }
        int days = 0;
        try {
            days = Integer.parseInt(this.tfUpdateInterval.getText().trim());
            if (days <= 0) {
                days = 30;
            }
        }
        catch (NumberFormatException e) {
            days = 30;
        }
        Config.getPref().putInt("pluginmanager.time-based-update.interval", days);
    }

    class TimeBasedPolicyChangeListener
    implements ChangeListener {
        TimeBasedPolicyChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            PluginUpdatePolicyPanel.this.lblUpdateInterval.setEnabled(!((JRadioButton)PluginUpdatePolicyPanel.this.rbTimeBasedUpatePolicy.get((Object)Policy.NEVER)).isSelected());
            PluginUpdatePolicyPanel.this.tfUpdateInterval.setEnabled(!((JRadioButton)PluginUpdatePolicyPanel.this.rbTimeBasedUpatePolicy.get((Object)Policy.NEVER)).isSelected());
        }
    }

    private static enum Policy {
        ASK("ask"),
        ALWAYS("always"),
        NEVER("never");

        private final String preferenceValue;

        private Policy(String preferenceValue) {
            this.preferenceValue = preferenceValue;
        }

        public String getPreferencesValue() {
            return this.preferenceValue;
        }

        static Policy fromPreferenceValue(String preferenceValue) {
            if (preferenceValue == null) {
                return null;
            }
            String prefValue = preferenceValue.trim().toLowerCase(Locale.ENGLISH);
            for (Policy p : Policy.values()) {
                if (!p.getPreferencesValue().equals(prefValue)) continue;
                return p;
            }
            return null;
        }
    }
}

