/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants;

import jakarta.ws.rs.core.Response;
import java.util.UUID;
import org.jboss.logging.Logger;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.events.EventType;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.grants.OAuth2GrantType;
import org.keycloak.protocol.oidc.grants.OAuth2GrantTypeBase;
import org.keycloak.protocol.oidc.utils.OAuth2Code;
import org.keycloak.protocol.oidc.utils.OAuth2CodeParser;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.util.DefaultClientSessionContext;
import org.keycloak.utils.MediaType;

public class PreAuthorizedCodeGrantType
extends OAuth2GrantTypeBase {
    private static final Logger LOGGER = Logger.getLogger(PreAuthorizedCodeGrantType.class);
    public static final String VC_ISSUANCE_FLOW = "VC-Issuance-Flow";

    public Response process(OAuth2GrantType.Context context) {
        LOGGER.debug((Object)"Process grant request for preauthorized.");
        this.setContext(context);
        String code = (String)this.formParams.getFirst((Object)"pre-authorized_code");
        if (code == null) {
            String errorMessage = "Missing parameter: pre-authorized_code";
            this.event.detail("reason", errorMessage);
            this.event.error("invalid_code");
            throw new CorsErrorResponseException(this.cors, "invalid_request", errorMessage, Response.Status.BAD_REQUEST);
        }
        OAuth2CodeParser.ParseResult result = OAuth2CodeParser.parseCode(this.session, code, this.realm, this.event);
        if (result.isIllegalCode()) {
            this.event.error("invalid_code");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "Code not valid", Response.Status.BAD_REQUEST);
        }
        if (result.isExpiredCode()) {
            this.event.error("expired_code");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "Code is expired", Response.Status.BAD_REQUEST);
        }
        AuthenticatedClientSessionModel clientSession = result.getClientSession();
        DefaultClientSessionContext sessionContext = DefaultClientSessionContext.fromClientSessionAndScopeParameter(clientSession, "openid", this.session);
        clientSession.setNote(VC_ISSUANCE_FLOW, "urn:ietf:params:oauth:grant-type:pre-authorized_code");
        sessionContext.setAttribute("grant_type", "urn:ietf:params:oauth:grant-type:pre-authorized_code");
        this.session.getContext().setClient(result.getClientSession().getClient());
        AccessToken accessToken = this.tokenManager.createClientAccessToken(this.session, clientSession.getRealm(), clientSession.getClient(), clientSession.getUserSession().getUser(), clientSession.getUserSession(), sessionContext);
        AccessTokenResponse tokenResponse = this.tokenManager.responseBuilder(clientSession.getRealm(), clientSession.getClient(), this.event, this.session, clientSession.getUserSession(), sessionContext).accessToken(accessToken).build();
        this.event.success();
        return this.cors.allowAllOrigins().add(Response.ok((Object)tokenResponse).type(MediaType.APPLICATION_JSON_TYPE));
    }

    public EventType getEventType() {
        return EventType.CODE_TO_TOKEN;
    }

    public static String getPreAuthorizedCode(KeycloakSession session, AuthenticatedClientSessionModel authenticatedClientSession, int expirationTime) {
        String codeId = UUID.randomUUID().toString();
        String nonce = SecretGenerator.getInstance().randomString();
        OAuth2Code oAuth2Code = new OAuth2Code(codeId, expirationTime, nonce, null, null, null, null, null, authenticatedClientSession.getUserSession().getId());
        return OAuth2CodeParser.persistCode(session, authenticatedClientSession, oAuth2Code);
    }
}

