/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.ArrayList;
import java.util.Collection;
import org.jivesoftware.smack.util.Function;
import org.jivesoftware.smack.util.StringUtils;

public class ToStringUtil {
    public static Builder builderFor(Class<?> clazz) {
        StringBuilder sb = new StringBuilder();
        sb.append(clazz.getSimpleName()).append('(');
        return new Builder(sb);
    }

    public static final class Builder {
        private final StringBuilder sb;

        private Builder(StringBuilder sb) {
            this.sb = sb;
        }

        public Builder addValue(String name, Object value2) {
            if (value2 == null) {
                return this;
            }
            if (this.sb.charAt(this.sb.length() - 1) != '(') {
                this.sb.append(' ');
            }
            this.sb.append(name).append("='").append(value2).append('\'');
            return this;
        }

        public <V> Builder add(String name, Collection<? extends V> values2, Function<?, V> toStringFunction) {
            if (values2.isEmpty()) {
                return this;
            }
            this.sb.append(' ').append(name).append('[');
            ArrayList<String> stringValues = new ArrayList<String>(values2.size());
            for (V value2 : values2) {
                String valueString = toStringFunction.apply(value2).toString();
                stringValues.add(valueString);
            }
            StringUtils.appendTo(stringValues, ", ", this.sb);
            this.sb.append(']');
            return this;
        }

        public String build() {
            this.sb.append(')');
            return this.sb.toString();
        }
    }
}

