/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.AccountAttributeValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AccountAttribute
implements Serializable {
    private String attributeName;
    private ListWithAutoConstructFlag<AccountAttributeValue> attributeValues;

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public AccountAttribute withAttributeName(String attributeName) {
        this.attributeName = attributeName;
        return this;
    }

    public List<AccountAttributeValue> getAttributeValues() {
        if (this.attributeValues == null) {
            this.attributeValues = new ListWithAutoConstructFlag();
            this.attributeValues.setAutoConstruct(true);
        }
        return this.attributeValues;
    }

    public void setAttributeValues(Collection<AccountAttributeValue> attributeValues) {
        if (attributeValues == null) {
            this.attributeValues = null;
            return;
        }
        ListWithAutoConstructFlag attributeValuesCopy = new ListWithAutoConstructFlag(attributeValues.size());
        attributeValuesCopy.addAll(attributeValues);
        this.attributeValues = attributeValuesCopy;
    }

    public AccountAttribute withAttributeValues(AccountAttributeValue ... attributeValues) {
        if (this.getAttributeValues() == null) {
            this.setAttributeValues(new ArrayList<AccountAttributeValue>(attributeValues.length));
        }
        for (AccountAttributeValue value : attributeValues) {
            this.getAttributeValues().add(value);
        }
        return this;
    }

    public AccountAttribute withAttributeValues(Collection<AccountAttributeValue> attributeValues) {
        if (attributeValues == null) {
            this.attributeValues = null;
        } else {
            ListWithAutoConstructFlag attributeValuesCopy = new ListWithAutoConstructFlag(attributeValues.size());
            attributeValuesCopy.addAll(attributeValues);
            this.attributeValues = attributeValuesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttributeName() != null) {
            sb.append("AttributeName: " + this.getAttributeName() + ",");
        }
        if (this.getAttributeValues() != null) {
            sb.append("AttributeValues: " + this.getAttributeValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttributeName() == null ? 0 : this.getAttributeName().hashCode());
        hashCode = 31 * hashCode + (this.getAttributeValues() == null ? 0 : ((Object)this.getAttributeValues()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountAttribute)) {
            return false;
        }
        AccountAttribute other = (AccountAttribute)obj;
        if (other.getAttributeName() == null ^ this.getAttributeName() == null) {
            return false;
        }
        if (other.getAttributeName() != null && !other.getAttributeName().equals(this.getAttributeName())) {
            return false;
        }
        if (other.getAttributeValues() == null ^ this.getAttributeValues() == null) {
            return false;
        }
        return other.getAttributeValues() == null || ((Object)other.getAttributeValues()).equals(this.getAttributeValues());
    }
}

