/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.color;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.color.CSSSystemColors;
import org.jfree.layouting.input.style.keys.color.ColorStyleKeys;
import org.jfree.layouting.input.style.keys.color.HtmlColors;
import org.jfree.layouting.input.style.values.CSSColorValue;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.functions.FunctionEvaluationException;
import org.jfree.layouting.layouter.style.functions.FunctionFactory;
import org.jfree.layouting.layouter.style.functions.values.StyleValueFunction;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;
import org.jfree.layouting.util.ColorUtil;

public class ColorResolveHandler
implements ResolveHandler {
    @Override
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[0];
    }

    @Override
    public void resolve(LayoutProcess layoutProcess, LayoutElement layoutElement, StyleKey styleKey) {
        CSSValue cSSValue;
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        CSSValue cSSValue2 = layoutContext.getValue(styleKey);
        if (cSSValue2 instanceof CSSColorValue) {
            return;
        }
        if (cSSValue2 instanceof CSSFunctionValue) {
            cSSValue = (CSSFunctionValue)cSSValue2;
            StyleValueFunction styleValueFunction = FunctionFactory.getInstance().getStyleFunction(cSSValue.getFunctionName());
            if (styleValueFunction == null) {
                cSSValue2 = HtmlColors.BLACK;
            } else {
                try {
                    cSSValue2 = styleValueFunction.evaluate(layoutProcess, layoutElement, (CSSFunctionValue)cSSValue);
                }
                catch (FunctionEvaluationException functionEvaluationException) {
                    cSSValue2 = HtmlColors.BLACK;
                }
            }
            if (cSSValue2 instanceof CSSColorValue) {
                layoutContext.setValue(styleKey, cSSValue2);
                return;
            }
        }
        if (!(cSSValue2 instanceof CSSConstant)) {
            layoutContext.setValue(styleKey, HtmlColors.BLACK);
            return;
        }
        if (CSSSystemColors.CURRENT_COLOR.equals(cSSValue2)) {
            layoutContext.setValue(styleKey, this.getCurrentColor(layoutElement));
            return;
        }
        cSSValue = ColorUtil.parseIdentColor(cSSValue2.getCSSText());
        if (cSSValue != null) {
            layoutContext.setValue(styleKey, cSSValue);
        } else {
            layoutContext.setValue(styleKey, HtmlColors.BLACK);
        }
    }

    protected CSSColorValue getCurrentColor(LayoutElement layoutElement) {
        LayoutContext layoutContext;
        CSSValue cSSValue;
        LayoutElement layoutElement2 = layoutElement.getParent();
        if (layoutElement2 != null && (cSSValue = (layoutContext = layoutElement2.getLayoutContext()).getValue(ColorStyleKeys.COLOR)) instanceof CSSColorValue) {
            return (CSSColorValue)cSSValue;
        }
        return HtmlColors.BLACK;
    }
}

