/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.vp8;

import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.codec.vpx.VpxUtils;
import org.jitsi.nlj.rtp.VideoRtpPacket;
import org.jitsi.nlj.rtp.codec.vp8.Vp8Packet;
import org.jitsi.rtp.util.RtpUtils;
import org.jitsi.videobridge.cc.vp8.VP8FrameProjection;

class VP8Frame {
    private final long ssrc;
    private final long timestamp;
    private int earliestKnownSequenceNumber;
    private int latestKnownSequenceNumber;
    private boolean seenStartOfFrame;
    private boolean seenEndOfFrame;
    private final int temporalLayer;
    private final int pictureId;
    private final int tl0PICIDX;
    private boolean isKeyframe;
    private VP8FrameProjection projection;
    private boolean accepted;

    VP8Frame(@NotNull Vp8Packet packet) {
        this.ssrc = packet.getSsrc();
        this.timestamp = packet.getTimestamp();
        this.earliestKnownSequenceNumber = packet.getSequenceNumber();
        this.latestKnownSequenceNumber = packet.getSequenceNumber();
        this.seenStartOfFrame = packet.isStartOfFrame();
        this.seenEndOfFrame = packet.isEndOfFrame();
        this.tl0PICIDX = packet.getTL0PICIDX();
        this.isKeyframe = packet.isKeyframe();
        this.pictureId = packet.getPictureId();
        this.temporalLayer = packet.getTemporalLayerIndex();
    }

    void addPacket(@NotNull Vp8Packet packet) {
        if (!this.matchesFrame(packet)) {
            throw new IllegalArgumentException("Non-matching packet added to frame");
        }
        int seq = packet.getSequenceNumber();
        if (RtpUtils.isOlderSequenceNumberThan(seq, this.earliestKnownSequenceNumber)) {
            this.earliestKnownSequenceNumber = seq;
        }
        if (RtpUtils.isNewerSequenceNumberThan(seq, this.latestKnownSequenceNumber)) {
            this.latestKnownSequenceNumber = seq;
        }
        if (packet.isStartOfFrame()) {
            this.seenStartOfFrame = true;
        }
        if (packet.isEndOfFrame()) {
            this.seenEndOfFrame = true;
        }
    }

    boolean isKeyframe() {
        return this.isKeyframe;
    }

    void setKeyframe(boolean k) {
        this.isKeyframe = k;
    }

    int getTemporalLayer() {
        return this.temporalLayer;
    }

    boolean isTL0() {
        return this.temporalLayer <= 0;
    }

    long getSsrc() {
        return this.ssrc;
    }

    long getTimestamp() {
        return this.timestamp;
    }

    public int getEarliestKnownSequenceNumber() {
        return this.earliestKnownSequenceNumber;
    }

    public int getLatestKnownSequenceNumber() {
        return this.latestKnownSequenceNumber;
    }

    public boolean hasSeenStartOfFrame() {
        return this.seenStartOfFrame;
    }

    public boolean hasSeenEndOfFrame() {
        return this.seenEndOfFrame;
    }

    public VP8FrameProjection getProjection() {
        return this.projection;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public void setAccepted(boolean a) {
        this.accepted = a;
    }

    public void setProjection(VP8FrameProjection projection) {
        this.projection = projection;
    }

    public int getPictureId() {
        return this.pictureId;
    }

    public int getTl0PICIDX() {
        return this.tl0PICIDX;
    }

    boolean matchesSSRC(@NotNull VP8Frame vp8Frame) {
        return this.ssrc == vp8Frame.ssrc;
    }

    private boolean matchesSSRC(@NotNull VideoRtpPacket pkt) {
        return this.ssrc == pkt.getSsrc();
    }

    boolean matchesFrame(@NotNull Vp8Packet pkt) {
        return this.matchesSSRC(pkt) && this.timestamp == pkt.getTimestamp();
    }

    void validateConsistency(@NotNull Vp8Packet pkt) {
        if (this.temporalLayer == pkt.getTemporalLayerIndex() && this.tl0PICIDX == pkt.getTL0PICIDX() && this.pictureId == pkt.getPictureId()) {
            return;
        }
        StringBuilder s2 = new StringBuilder().append("Packet").append(" ssrc ").append(pkt.getSsrc()).append(", seq ").append(pkt.getSequenceNumber()).append(", picture id ").append(pkt.getPictureId()).append(", timestamp ").append(pkt.getTimestamp()).append(" is not consistent with frame").append(" ssrc ").append(this.ssrc).append(", seq ").append(this.earliestKnownSequenceNumber).append("-").append(this.latestKnownSequenceNumber).append(", picture id ").append(this.pictureId).append(", timestamp ").append(this.timestamp).append(": ");
        boolean complained = false;
        if (this.temporalLayer != pkt.getTemporalLayerIndex()) {
            s2.append("packet temporal layer ").append(pkt.getTemporalLayerIndex()).append(" != frame temporal layer ").append(this.temporalLayer);
            complained = true;
        }
        if (this.tl0PICIDX != pkt.getTL0PICIDX()) {
            if (complained) {
                s2.append("; ");
            }
            s2.append("packet TL0PICIDX ").append(pkt.getTL0PICIDX()).append(" != frame TL0PICIDX ").append(this.tl0PICIDX);
            complained = true;
        }
        if (this.pictureId != pkt.getPictureId()) {
            if (complained) {
                s2.append("; ");
            }
            s2.append("packet PictureID ").append(pkt.getPictureId()).append(" != frame PictureID ").append(this.pictureId);
        }
        throw new RuntimeException(s2.toString());
    }

    boolean isImmediatelyAfter(@NotNull VP8Frame otherFrame) {
        return this.pictureId == VpxUtils.applyExtendedPictureIdDelta(otherFrame.getPictureId(), 1);
    }
}

