/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.SIPObject;

public final class CallIdentifier
extends SIPObject {
    private static final long serialVersionUID = 7314773655675451377L;
    protected String localId;
    protected String host;

    public CallIdentifier() {
    }

    public CallIdentifier(String localId, String host) {
        this.localId = localId;
        this.host = host;
    }

    public CallIdentifier(String cid) throws IllegalArgumentException {
        this.setCallID(cid);
    }

    @Override
    public String encode() {
        return this.encode(new StringBuilder()).toString();
    }

    @Override
    public StringBuilder encode(StringBuilder buffer) {
        buffer.append(this.localId);
        if (this.host != null) {
            buffer.append("@").append(this.host);
        }
        return buffer;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        CallIdentifier that = (CallIdentifier)other;
        if (this.localId.compareTo(that.localId) != 0) {
            return false;
        }
        if (this.host == that.host) {
            return true;
        }
        if (this.host == null && that.host != null || this.host != null && that.host == null) {
            return false;
        }
        return this.host.compareToIgnoreCase(that.host) == 0;
    }

    public int hashCode() {
        if (this.localId == null) {
            throw new UnsupportedOperationException("Hash code called before id is set");
        }
        return this.localId.hashCode();
    }

    public String getLocalId() {
        return this.localId;
    }

    public String getHost() {
        return this.host;
    }

    public void setLocalId(String localId) {
        this.localId = localId;
    }

    public void setCallID(String cid) throws IllegalArgumentException {
        if (cid == null) {
            throw new IllegalArgumentException("NULL!");
        }
        int index = cid.indexOf(64);
        if (index == -1) {
            this.localId = cid;
            this.host = null;
        } else {
            this.localId = cid.substring(0, index);
            this.host = cid.substring(index + 1, cid.length());
            if (this.localId == null || this.host == null) {
                throw new IllegalArgumentException("CallID  must be token@token or token");
            }
        }
    }

    public void setHost(String host) {
        this.host = host;
    }
}

