/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.colopedia;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ModifierFormat;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaGameObjectTypePanel;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;

public class GoodsDetailPanel
extends ColopediaGameObjectTypePanel<GoodsType> {
    public GoodsDetailPanel(FreeColClient freeColClient, ColopediaPanel colopediaPanel) {
        super(freeColClient, colopediaPanel, ColopediaAction.PanelType.GOODS.getKey());
    }

    @Override
    public void addSubTrees(DefaultMutableTreeNode root) {
        super.addSubTrees(root, this.getSpecification().getGoodsTypeList());
    }

    @Override
    public void buildDetail(String id, JPanel panel) {
        if (this.getId().equals(id)) {
            return;
        }
        GoodsType type = this.getSpecification().getGoodsType(id);
        panel.setLayout(new MigLayout("wrap 4", "[]20[]"));
        JLabel name = Utility.localizedHeaderLabel(type, Utility.FONTSPEC_SUBTITLE);
        panel.add((Component)name, "span, align center, wrap 40");
        if (type.isFarmed()) {
            ArrayList<TileImprovementType> improvements = new ArrayList<TileImprovementType>();
            ArrayList<Modifier> modifiers = new ArrayList<Modifier>();
            for (TileImprovementType improvementType : this.getSpecification().getTileImprovementTypeList()) {
                Modifier productionModifier = improvementType.getProductionModifier(type);
                if (productionModifier == null) continue;
                improvements.add(improvementType);
                modifiers.add(productionModifier);
            }
            panel.add((Component)Utility.localizedLabel("colopedia.goods.improvedBy"), "newline 20, top");
            if (improvements.isEmpty()) {
                panel.add((Component)Utility.localizedLabel("none"), "span");
            } else {
                for (int index = 0; index < improvements.size(); ++index) {
                    String constraints = index == 0 ? "span" : "skip, span";
                    panel.add((Component)Utility.localizedLabel(((StringTemplate)StringTemplate.template("colopedia.goods.improvement").addName("%name%", (FreeColObject)improvements.get(index))).addName("%amount%", ModifierFormat.getModifierAsString((Modifier)modifiers.get(index)))), constraints);
                }
            }
        } else {
            panel.add((Component)Utility.localizedLabel("colopedia.goods.madeFrom"), "newline 20");
            if (type.isRefined()) {
                panel.add((Component)this.getGoodsButton(type.getInputType()), "span");
            } else {
                panel.add((Component)Utility.localizedLabel("nothing"), "span");
            }
        }
        panel.add((Component)Utility.localizedLabel("colopedia.goods.makes"), "newline 20");
        if (type.isRawMaterial()) {
            panel.add((Component)this.getGoodsButton(type.getOutputType()), "span");
        } else if (type.getStoredAs() != type) {
            panel.add((Component)this.getGoodsButton(type.getStoredAs()), "span");
        } else {
            panel.add((Component)Utility.localizedLabel("nothing"), "span");
        }
        if (type.isBuildingMaterial()) {
            ArrayList buildingTypes = new ArrayList();
            boolean allTypes = this.filterBuildables(this.getSpecification().getBuildingTypeList(), buildingTypes, type);
            if (!buildingTypes.isEmpty()) {
                panel.add((Component)Utility.localizedLabel("colopedia.goods.buildings"), "newline 20");
                if (allTypes) {
                    JButton button = this.getButton(ColopediaAction.PanelType.BUILDINGS, Messages.message("colopedia.goods.allBuildings"), null);
                    panel.add((Component)button, "span");
                } else {
                    int count = 0;
                    for (Object building : buildingTypes) {
                        JButton label = this.getButton((FreeColSpecObjectType)building);
                        if (count > 0 && count % 3 == 0) {
                            panel.add((Component)label, "skip");
                        } else {
                            panel.add(label);
                        }
                        ++count;
                    }
                }
            }
            ArrayList roles = new ArrayList();
            allTypes = this.filterBuildables(this.getSpecification().getRolesList(), roles, type);
            if (!roles.isEmpty()) {
                panel.add((Component)Utility.localizedLabel("colopedia.goods.equipment"), "newline 20");
                int count = 0;
                for (Role role : roles) {
                    JLabel label = Utility.localizedLabel(Messages.getName(role));
                    if (count > 0 && count % 3 == 0) {
                        panel.add((Component)label, "skip");
                    } else {
                        panel.add(label);
                    }
                    ++count;
                }
            }
            ArrayList unitTypes = new ArrayList();
            allTypes = this.filterBuildables(this.getSpecification().getUnitTypeList(), unitTypes, type);
            if (!unitTypes.isEmpty()) {
                panel.add((Component)Utility.localizedLabel("colopedia.goods.units"), "newline 20");
                if (allTypes) {
                    JButton button = this.getButton(ColopediaAction.PanelType.UNITS, Messages.message("colopedia.goods.allUnits"), null);
                    panel.add((Component)button, "span");
                } else {
                    int count = 0;
                    for (UnitType unit : unitTypes) {
                        JButton label = this.getButton(unit);
                        if (count > 0 && count % 3 == 0) {
                            panel.add((Component)label, "skip");
                        } else {
                            panel.add(label);
                        }
                        ++count;
                    }
                }
            }
        }
        if (type.getBreedingNumber() < Integer.MAX_VALUE) {
            panel.add((Component)Utility.localizedLabel("colopedia.goods.breedingNumber"), "newline 20");
            panel.add(new JLabel(Integer.toString(type.getBreedingNumber())));
        }
        panel.add((Component)Utility.localizedLabel("colopedia.goods.description"), "newline 20");
        panel.add((Component)Utility.localizedTextArea(Messages.descriptionKey(type), 30), "span, growx");
    }

    private <T extends BuildableType> boolean filterBuildables(List<T> input, List<T> output, GoodsType type) {
        boolean result = false;
        for (BuildableType bt : input) {
            if (!bt.needsGoodsToBuild() || !CollectionUtils.any(bt.getRequiredGoods(), AbstractGoods.matches(type))) continue;
            output.add(bt);
            result = true;
        }
        return result;
    }
}

